// Cytosim was created by Francois Nedelec. Copyright 2007-2017 EMBL.

#ifndef CUTTER_H
#define CUTTER_H

#include "hand.h"
class CutterProp;

/// A Hand that can cut a Fiber
/**
 The Cutter is a Hand, and thus can bind and unbind from fibers.
 
 A bound Cutter can cut the fiber at the position where it is attached.
 The rate of cutting is set by @ref CutterPar "cutting_rate".
 
 Depending on the type of fiber, the new ends generated by cutting 
 will have specific dynamic states. Most likely they would be shrinking.
 
 See Examples and the @ref CutterPar.
 @ingroup HandGroup
 */
class Cutter : public Hand
{
private:
    
    /// disabled default constructor
    Cutter();
    
    /// Gillespie countdown timer
    real     gspTime;

public:
    
    /// Property
    CutterProp const* prop;
    
    /// constructor
    Cutter(CutterProp const*, HandMonitor*);
    
    /// destructor
    ~Cutter() {}
    
    /// cut current fiber at attachement position
    void   cut();
    
    /// simulate when `this` is attached but not under load
    void   stepUnloaded();
    
    /// simulate when `this` is attached and under load
    void   stepLoaded(Vector const& force, real force_norm);
    
};

#endif

