# Cytosim's Tutorials

The first tutorial is aimed to be a pleasant and quick way to learn Cytosim:

- [Introductory tutorial](tuto_introduction.md)

### Specialized topics

The following tutorials correspond to work published in the past and they are all independent. They illustrate different capacities that are still present in Cytosim.

- [Self-organization of microtubules and motors](tuto_self.md)
- [Gliding/motility assays with immobilized motors](tuto_gliding.md)
- [Aster positionning by microtubule pushing or motor pulling](tuto_centering.md)
- [Network contraction driven by motors](tuto_contract_motor.md)
- [Network contraction with two contractile mechanisms](tuto_contract2.md)
- [Network contraction driven by filament disassembly](tuto_contract3.md)
- [Polar vs. nematic microtubule organization](tuto_polar_nematic.md)

### Best practice

- [Varying parameters in the simulations](tuto_scans.md)
- [Basic Python scripting](tuto_scripting.md)

### Unfinished

- [Chromosome capture](tuto_capture.md)
- [Nucleus positionning in fungi](tuto_nucleus.md)
- [Polarity](tuto_polarity.md)
- [Bipolarity](tuto_bipolarity.md)


[Back to main page](../index.md)
