# Generated by Django 4.2.14 on 2025-03-12 23:58

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("locations", "0006_merge_20250129_1542"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("organizations", "0004_organizationcodeablereference"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("visionprescriptions", "0001_initial"),
        ("devices", "0007_alter_device_status_and_more"),
        ("practitioners", "0011_practitionerrolereference"),
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
        ("provenances", "0001_initial"),
        ("patients", "0007_patientorganizationreference"),
        ("base", "0018_merge_20250307_1944"),
    ]

    operations = [
        migrations.CreateModel(
            name="Transport",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("preparation", "Preparation"),
                            ("in-progress", "In Progress"),
                            ("not-done", "Not Done"),
                            ("suspended", "Suspended"),
                            ("stopped", "Stopped"),
                            ("on-hold", "On Hold"),
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in Error"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("description", models.TextField(null=True)),
                ("completion_time", models.DateTimeField(null=True)),
                ("authored_on", models.DateTimeField(null=True)),
                ("last_modified", models.DateTimeField(null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportRestrictionRecipientReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_group",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportRestriction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("repetition", models.PositiveIntegerField(null=True)),
                (
                    "period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_period",
                        to="base.period",
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_restriction_recipient",
                        to="transports.transportrestrictionrecipientreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportRequesterReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_requester_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "transport",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_reference_transport",
                        to="transports.transport",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportOwnerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_healthcare_service",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_owner_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportOutput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_output_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportInput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_input_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TransportBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_based_on_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_based_on_medication_request",
                        to="medicationrequests.medicationrequest",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_based_on_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
                (
                    "vision_prescription",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="transport_based_on_vision_prescription",
                        to="visionprescriptions.visionprescription",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="transport",
            name="based_on",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_based_on",
                to="transports.transportbasedonreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="code",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_code",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="current_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_current_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_encounter",
                to="encounters.encounterreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="focus",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_focus",
                to="base.reference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="for_value",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_for_value",
                to="base.reference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="group_identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_group_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="history",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_history",
                to="transports.transportreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="identifier",
            field=models.ManyToManyField(
                blank=True, related_name="transport_identifier", to="base.identifier"
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="input",
            field=models.ManyToManyField(
                blank=True,
                related_name="transport_input",
                to="transports.transportinput",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="note",
            field=models.ManyToManyField(
                blank=True, related_name="transport_note", to="base.annotation"
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="output",
            field=models.ManyToManyField(
                blank=True,
                related_name="transport_output",
                to="transports.transportoutput",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="owner",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_owner",
                to="transports.transportownerreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="part_of",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_part_of",
                to="transports.transportreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="performer_type",
            field=models.ManyToManyField(
                blank=True,
                related_name="transport_performer_type",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_reason",
                to="base.codeablereference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="relevant_history",
            field=models.ManyToManyField(
                blank=True,
                related_name="transport_relevant_history",
                to="provenances.provenancereference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="requested_location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_requested_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="requester",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_requester",
                to="transports.transportrequesterreference",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="restriction",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_restriction",
                to="transports.transportrestriction",
            ),
        ),
        migrations.AddField(
            model_name="transport",
            name="status_reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="transport_status_reason",
                to="base.codeableconcept",
            ),
        ),
    ]
