# Generated by Django 4.2.14 on 2025-03-11 19:35

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("practitioners", "0011_practitionerrolereference"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("base", "0018_merge_20250307_1944"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("locations", "0006_merge_20250129_1542"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("devices", "0007_alter_device_status_and_more"),
        ("provenances", "0001_initial"),
        ("coverages", "0005_coverageclaimresponsereference"),
        ("organizations", "0004_organizationcodeablereference"),
        ("patients", "0007_patientorganizationreference"),
    ]

    operations = [
        migrations.CreateModel(
            name="Task",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("instantiate_uri", models.URLField(null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("requested", "Requested"),
                            ("received", "Received"),
                            ("accepted", "Accepted"),
                            ("rejected", "Rejected"),
                            ("ready", "Ready"),
                            ("cancelled", "Cancelled"),
                            ("in-progress", "In Progress"),
                            ("on-hold", "On Hold"),
                            ("failed", "Failed"),
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "intent",
                    models.CharField(
                        choices=[
                            ("unknown", "unknown"),
                            ("proposal", "proposal"),
                            ("plan", "plan"),
                            ("order", "order"),
                            ("original-order", "original-order"),
                            ("reflex-order", "reflex-order"),
                            ("filler-order", "filler-order"),
                            ("instance-order", "instance-order"),
                            ("option", "option"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "priority",
                    models.CharField(
                        choices=[
                            ("routine", "routine"),
                            ("urgent", "urgent"),
                            ("asap", "asap"),
                            ("stat", "stat"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("do_not_perform", models.BooleanField(default=False)),
                ("description", models.TextField(null=True)),
                ("authored_on", models.DateTimeField(null=True)),
                ("last_modified", models.DateTimeField(null=True)),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True, related_name="task_based_on", to="base.reference"
                    ),
                ),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
                (
                    "execution_period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_execution_period",
                        to="base.period",
                    ),
                ),
                (
                    "focus",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_focus",
                        to="base.reference",
                    ),
                ),
                (
                    "for_value",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_for",
                        to="base.reference",
                    ),
                ),
                (
                    "group_identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_group_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        related_name="task_identifier", to="base.identifier"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskRestrictionRecipientReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_practitioner_care_team",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_recipient_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskRestriction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("repetition", models.PositiveIntegerField(null=True)),
                (
                    "period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_restriction_period",
                        to="base.period",
                    ),
                ),
                (
                    "recipient",
                    models.ManyToManyField(
                        blank=True,
                        related_name="ask_restrictions_recipient",
                        to="tasks.taskrestrictionrecipientreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskRequesterReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requester_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskRequestedPerformerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_practitioner_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_practitioner_healthcare_service",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_requested_performer_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_reference_task",
                        to="tasks.task",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_practitioner_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_actor",
                        to="tasks.taskperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_performer_model",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskOwnerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_practitioner_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_owner_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskOutput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_output_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TaskInput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="task_input_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="task",
            name="input",
            field=models.ManyToManyField(
                blank=True, related_name="task_input", to="tasks.taskinput"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="insurance",
            field=models.ManyToManyField(
                blank=True,
                related_name="task_insurance",
                to="coverages.coverageclaimresponsereference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="task_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="note",
            field=models.ManyToManyField(
                blank=True, related_name="task_note", to="base.annotation"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="output",
            field=models.ManyToManyField(
                blank=True, related_name="task_output", to="tasks.taskoutput"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="owner",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="task_owner",
                to="tasks.taskownerreference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="part_of",
            field=models.ManyToManyField(
                blank=True, related_name="task_part_of", to="tasks.taskreference"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="performer",
            field=models.ManyToManyField(
                blank=True, related_name="task_performer", to="tasks.taskperformer"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="reason",
            field=models.ManyToManyField(
                blank=True, related_name="task_reason", to="base.codeablereference"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="relevant_history",
            field=models.ManyToManyField(
                blank=True,
                related_name="task_relevant_history",
                to="provenances.provenancereference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="requested_performer",
            field=models.ManyToManyField(
                blank=True,
                related_name="task_requested_performer",
                to="tasks.taskrequestedperformerreference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="requested_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="task_requested_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="requester",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="task_requester",
                to="tasks.taskrequesterreference",
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="restriction",
            field=models.ManyToManyField(
                blank=True, related_name="task_restriction", to="tasks.taskrestriction"
            ),
        ),
        migrations.AddField(
            model_name="task",
            name="status_reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="task_status_reason",
                to="base.codeablereference",
            ),
        ),
    ]
