# Generated by Django 4.2.14 on 2025-03-14 19:16

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("devicedefinitions", "0002_devicedefinitiondeviceversion_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("locations", "0006_merge_20250129_1542"),
        ("inventoryitems", "0002_alter_inventoryitem_identifier"),
        ("biologicallyderivedproducts", "0001_initial"),
        ("practitioners", "0011_practitionerrolereference"),
        ("conditions", "0006_merge_20250217_1423"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("diagnosticreports", "0005_diagnosticreportdocumentreferencereference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("organizations", "0004_organizationcodeablereference"),
        (
            "nutritionorders",
            "0005_rename_instantiated_nutritionorder_instantiates_and_more",
        ),
        ("substances", "0002_substancecodeablereference"),
        ("devices", "0007_alter_device_status_and_more"),
        ("base", "0018_merge_20250307_1944"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("observations", "0009_documentreferenceobservationreference"),
        (
            "documentreferences",
            "0003_rename_base_on_documentreference_based_on_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="SupplyRequest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("active", "Active"),
                            ("suspended", "Suspended"),
                            ("cancelled", "Cancelled"),
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in error"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=200,
                    ),
                ),
                (
                    "intent",
                    models.CharField(
                        choices=[
                            ("proposal", "Proposal"),
                            ("plan", "Plan"),
                            ("directive", "Directive"),
                            ("order", "Order"),
                            ("original-order", "Original Order"),
                            ("reflex-order", "Reflex Order"),
                            ("filler-order", "Filler Order"),
                            ("instance-order", "Instance Order"),
                            ("option", "Option"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "priority",
                    models.CharField(
                        choices=[
                            ("routine", "Routine"),
                            ("urgent", "Urgent"),
                            ("stat", "Stat"),
                            ("asap", "ASAP"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("occurrence_date_time", models.DateTimeField(blank=True, null=True)),
                ("authored_on", models.DateTimeField(blank=True, null=True)),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True,
                        related_name="supply_request_based_on",
                        to="base.reference",
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_category",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "deliver_for",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_for",
                        to="patients.patientreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestSupplierReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_supplier_reference_healthcare_service",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_supplier_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_supplier_reference_organization",
                        to="organizations.organization",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestRequesterReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_reques_requestert_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_requester_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "supply_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reference_supply_request",
                        to="supplyrequests.supplyrequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestReasonReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reason_reference_condition",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reason_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "document_reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reason_reference_document_reference",
                        to="documentreferences.documentreference",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reason_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_reason_reference_observation",
                        to="observations.observation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestParameter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value_boolean", models.BooleanField(null=True)),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_parameter_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_codeable_concept",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_parameter_value_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_parameter_value_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "value_range",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_parameter_value_range",
                        to="base.range",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestItemReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_derived_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_biologically_derived_product",
                        to="biologicallyderivedproducts.biologicallyderivedproduct",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "device_definition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_device_definition",
                        to="devicedefinitions.devicedefinition",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "inventory_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_inventory_item",
                        to="inventoryitems.inventoryitem",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "nutrition_order",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_nutrition_order",
                        to="nutritionorders.nutritionorder",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_item_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestDeliverToReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_to_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_to_reference_location",
                        to="locations.location",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_to_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_to_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_to_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyRequestDeliverFromReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_from_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_from_reference_location",
                        to="locations.location",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_request_deliver_from_reference_organization",
                        to="organizations.organization",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="deliver_from",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_deliver_from",
                to="supplyrequests.supplyrequestdeliverfromreference",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="deliver_to",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_deliver_to",
                to="supplyrequests.supplyrequestdelivertoreference",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="supply_request_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="item",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_item",
                to="supplyrequests.supplyrequestitemreference",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="occurrence_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_occurrence_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="occurrence_timing",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_occurrence_timing",
                to="base.timing",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="parameter",
            field=models.ManyToManyField(
                blank=True,
                related_name="supply_request_parameter",
                to="supplyrequests.supplyrequestparameter",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_quantity",
                to="base.quantity",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_reason",
                to="supplyrequests.supplyrequestreasonreference",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="requester",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_requester",
                to="supplyrequests.supplyrequestrequesterreference",
            ),
        ),
        migrations.AddField(
            model_name="supplyrequest",
            name="supplier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_request_supplier",
                to="supplyrequests.supplyrequestsupplierreference",
            ),
        ),
    ]
