# Generated by Django 4.2.14 on 2025-03-14 11:29

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("nutritionproducts", "0003_remove_nutritionproductnutrients_allergen"),
        ("organizations", "0004_organizationcodeablereference"),
        ("inventoryitems", "0002_alter_inventoryitem_identifier"),
        ("substances", "0002_substancecodeablereference"),
        ("practitioners", "0011_practitionerrolereference"),
        ("base", "0018_merge_20250307_1944"),
        ("contracts", "0008_contracttermofferparty_reference_and_more"),
        ("biologicallyderivedproducts", "0001_initial"),
        ("locations", "0006_merge_20250129_1542"),
        ("devices", "0007_alter_device_status_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
    ]

    operations = [
        migrations.CreateModel(
            name="SupplyDelivery",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("in-progress", "In Progress"),
                            ("completed", "Completed"),
                            ("abandoned", "Abandoned"),
                            ("entered-in-error", "Entered In Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("occurrence_date_time", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliverySupplierReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplier_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplier_references_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplier_references_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplier_references_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliverySuppliedItemItemReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_derived_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_biologically_derived_product",
                        to="biologicallyderivedproducts.biologicallyderivedproduct",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "inventory_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_inventory_item",
                        to="inventoryitems.inventoryitem",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "nutrition_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_nutrition_product",
                        to="nutritionproducts.nutritionproduct",
                    ),
                ),
                (
                    "sustance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_references_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliverySuppliedItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "condition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_condition",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "item_codealbe_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_codealbe_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "item_reference",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_item_reference",
                        to="supplydelivery.supplydeliverysupplieditemitemreference",
                    ),
                ),
                (
                    "quantity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_supplied_item_quantity",
                        to="base.quantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliveryReceiverReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_receiver_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_receiver_references_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_receiver_references_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliveryDestinationReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_destination_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_destination_references_location",
                        to="locations.location",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_destination_references_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_destination_references_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_destination_references_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SupplyDeliveryContractReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "contract",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_contracts_reference_contract",
                        to="contracts.contract",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_contracts_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "supply_delivery",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_contracts_supply_delivery",
                        to="supplydelivery.supplydelivery",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="destination",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_destination",
                to="supplydelivery.supplydeliverydestinationreference",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="identifier",
            field=models.ManyToManyField(
                related_name="supply_delivery_identifier", to="base.identifier"
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="occurrence_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_occurrence_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="occurrence_timing",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_occurrence",
                to="base.timing",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="part_of",
            field=models.ManyToManyField(
                related_name="supply_delivery_part_of",
                to="supplydelivery.supplydeliverycontractreference",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="patient",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_patient",
                to="patients.patientreference",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="receiver",
            field=models.ManyToManyField(
                related_name="supply_delivery_receiver",
                to="supplydelivery.supplydeliveryreceiverreference",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="stage",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_stage",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="supplied",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_supplied",
                to="supplydelivery.supplydeliverysupplierreference",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="supplied_item",
            field=models.ManyToManyField(
                related_name="supply_delivery_supplied_item",
                to="supplydelivery.supplydeliverysupplieditem",
            ),
        ),
        migrations.AddField(
            model_name="supplydelivery",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="supply_delivery_type",
                to="base.codeableconcept",
            ),
        ),
        migrations.CreateModel(
            name="SupplyDeliverReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "supply_delivery",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="supply_delivery_reference_contract",
                        to="supplydelivery.supplydelivery",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
