# Generated by Django 4.2.14 on 2025-02-18 11:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("patients", "0007_patientorganizationreference"),
        ("procedures", "0001_initial"),
        ("devices", "0007_alter_device_status_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("substances", "0002_substancecodeablereference"),
        ("base", "0012_alter_repeat_duration_unit_alter_repeat_period_unit"),
        ("servicerequests", "0004_alter_servicerequest_intent"),
        ("specimens", "0001_initial"),
    ]

    operations = [
        migrations.RenameModel(
            old_name="SpecimenCollections",
            new_name="SpecimenCollection",
        ),
        migrations.AddField(
            model_name="specimenprocessing",
            name="additive",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_processing_additive",
                to="substances.substancereference",
            ),
        ),
        migrations.AlterField(
            model_name="specimen",
            name="request",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_request",
                to="servicerequests.servicerequestreference",
            ),
        ),
        migrations.AlterField(
            model_name="specimencollection",
            name="quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_collections_method",
                to="base.simplequantity",
            ),
        ),
        migrations.AlterField(
            model_name="specimencontainer",
            name="specimen_quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_container_specimen_quantity",
                to="base.simplequantity",
            ),
        ),
        migrations.CreateModel(
            name="SpecimenProcessingPerformerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AlterField(
            model_name="specimenprocessing",
            name="performer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_processing_performer",
                to="specimens.specimenprocessingperformerreference",
            ),
        ),
        migrations.DeleteModel(
            name="SpecimenPerformerReference",
        ),
    ]
