# Generated by Django 4.2.14 on 2025-02-13 14:46

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("substances", "0002_substancecodeablereference"),
        ("organizations", "0003_organization_endpoint"),
        ("servicerequests", "0004_alter_servicerequest_intent"),
        ("base", "0012_alter_repeat_duration_unit_alter_repeat_period_unit"),
        ("devices", "0007_alter_device_status_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("locations", "0006_merge_20250129_1542"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("procedures", "0001_initial"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("biologicallyderivedproducts", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="SepcimenFeature",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("description", models.TextField(null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_feature_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Specimen",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("available", "Available"),
                            ("unavailable", "Unavailable"),
                            ("unsatisfactory", "Unsatisfactory"),
                            ("entered-in-error", "Entered in Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("received_time", models.DateTimeField(null=True)),
                (
                    "combined",
                    models.CharField(
                        choices=[("grouped", "Grouped"), ("pooled", "Pooled")],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "accession_identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_accession_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenPerformerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_performer_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenSubjectReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_driven_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_biologically_driven_product",
                        to="biologicallyderivedproducts.biologicallyderivedproduct",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_group",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_location",
                        to="locations.location",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_subject_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "specimen",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_reference_specimen",
                        to="specimens.specimen",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenProcessing",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("description", models.TextField(null=True)),
                ("time_date_time", models.DateTimeField(null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_processing_device",
                        to="devices.devicereference",
                    ),
                ),
                (
                    "method",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_processing_method",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "performer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_processing_performer",
                        to="specimens.specimenperformerreference",
                    ),
                ),
                (
                    "time_duration",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_processing_time_duration",
                        to="base.duration",
                    ),
                ),
                (
                    "time_period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_processing_time_period",
                        to="base.period",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenContainer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_container_device",
                        to="devices.devicereference",
                    ),
                ),
                (
                    "specimen_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_container_specimen_quantity",
                        to="base.quantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenCollectorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collector_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SpecimenCollections",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("collected_date", models.DateTimeField(null=True)),
                (
                    "collected_period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_collected_period",
                        to="base.period",
                    ),
                ),
                (
                    "collector",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_collector",
                        to="specimens.specimencollectorreference",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_device",
                        to="devices.devicecodeablereference",
                    ),
                ),
                (
                    "duration",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_duration",
                        to="base.duration",
                    ),
                ),
                (
                    "fasting_status_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_fasting_status_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "fasting_status_duration",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_fasting_status_duration",
                        to="base.duration",
                    ),
                ),
                (
                    "method",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_method",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_procedure",
                        to="procedures.procedurereference",
                    ),
                ),
                (
                    "quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="specimen_collections_method",
                        to="base.quantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="specimen",
            name="collections",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_collections",
                to="specimens.specimencollections",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="condition",
            field=models.ManyToManyField(
                blank=True, related_name="specimen_condition", to="base.codeableconcept"
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="container",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_container",
                to="specimens.specimencontainer",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="feature",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_feature",
                to="specimens.sepcimenfeature",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="identifier",
            field=models.ManyToManyField(
                blank=True, related_name="specimen_identifier", to="base.identifier"
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="note",
            field=models.ManyToManyField(
                blank=True, related_name="specimen_note", to="base.annotation"
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="parent",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_parent",
                to="specimens.specimenreference",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="processing",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_processing",
                to="specimens.specimenprocessing",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="request",
            field=models.ManyToManyField(
                blank=True,
                related_name="specimen_request",
                to="servicerequests.servicerequest",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="role",
            field=models.ManyToManyField(
                blank=True, related_name="specimen_role", to="base.codeableconcept"
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="subject",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_subject",
                to="specimens.specimensubjectreference",
            ),
        ),
        migrations.AddField(
            model_name="specimen",
            name="type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="specimen_type",
                to="base.codeableconcept",
            ),
        ),
    ]
