# Generated by Django 4.2.14 on 2025-02-04 11:52

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0010_expression_relativetime'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='SpecimenDefinitionTypeTestedHandling',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instruction', models.TextField(null=True)),
                ('max_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_handling_max_duration', to='base.quantity')),
                ('temperature_qualifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_handling_temperature_qualifier', to='base.codeableconcept')),
                ('temperature_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_handling_temperature_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpecimenDefinitionTypeTestedContainer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('description', models.TextField(null=True)),
                ('minimum_volume_string', models.CharField(max_length=255, null=True)),
                ('preparation', models.TextField(null=True)),
                ('additive_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_additive_codeable_concept', to='base.codeableconcept')),
                ('cap', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_cap', to='base.codeableconcept')),
                ('capacity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_capacity', to='base.quantity')),
                ('material', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_material', to='base.codeableconcept')),
                ('minimum_volume_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_minimum_volume_quantity', to='base.quantity')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpecimenDefinitionTypeTested',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_derived', models.BooleanField(null=True)),
                ('preference', models.CharField(choices=[('preferred', 'preferred'), ('alternate', 'alternate')], default='preferred', max_length=255)),
                ('requirements', models.TextField(null=True)),
                ('single_use', models.BooleanField(null=True)),
                ('container', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_container', to='specimendefinitions.specimendefinitiontypetestedcontainer')),
                ('handling', models.ManyToManyField(blank=True, related_name='specimen_definition_type_tested_handling', to='specimendefinitions.specimendefinitiontypetestedhandling')),
                ('retention_criterion', models.ManyToManyField(blank=True, related_name='specimen_definition_type_tested_retention_criterion', to='base.codeableconcept')),
                ('retention_time', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_retention_time', to='base.quantity')),
                ('testing_destination', models.ManyToManyField(blank=True, related_name='specimen_definition_type_tested_testing_destination', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_tested_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpecimenDefinition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('uri', models.URLField(null=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('version_algorithm_string', models.CharField(max_length=255, null=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('derived_from_uri', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(), null=True, size=None)),
                ('status', models.CharField(choices=[('draft', 'draft'), ('active', 'active'), ('retired', 'retired'), ('unknown', 'unknown')], default='active', max_length=255)),
                ('experimental', models.BooleanField(null=True)),
                ('date', models.DateField(null=True)),
                ('publisher', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
                ('purpose', models.TextField(null=True)),
                ('copyright', models.TextField(null=True)),
                ('copyright_label', models.CharField(max_length=255, null=True)),
                ('approval_date', models.DateField(null=True)),
                ('last_review_date', models.DateField(null=True)),
                ('time_aspect', models.CharField(max_length=255, null=True)),
                ('collection', models.ManyToManyField(blank=True, related_name='specimen_definition_collection', to='base.codeableconcept')),
                ('contact', models.ManyToManyField(blank=True, related_name='specimen_definition_contact', to='base.contactdetail')),
                ('effective_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_effective_period', to='base.period')),
                ('identifier', models.ManyToManyField(blank=True, related_name='specimen_definitions_identifier', to='base.identifier')),
                ('jurisdiction', models.ManyToManyField(blank=True, related_name='specimen_definition_jurisdiction', to='base.codeableconcept')),
                ('patient_preparation', models.ManyToManyField(blank=True, related_name='specimen_definition_patient_preparation', to='base.codeableconcept')),
                ('subject_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_subject_codeable_concept', to='base.codeableconcept')),
                ('subject_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_subject_reference', to='groups.groupreference')),
                ('type_collected', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_type_collected', to='base.codeableconcept')),
                ('use_context', models.ManyToManyField(blank=True, related_name='specimen_definition_use_context', to='base.usagecontext')),
                ('version_algorithm_coding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='specimen_definition_version_algorithm_coding', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
