# Generated by Django 4.2.14 on 2025-01-06 22:48

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('schedules', '0001_initial'),
        ('base', '0002_initial'),
        ('practitioners', '0001_initial'),
        ('healthcareservices', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Slot',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('appointment_type', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('walkin', 'Walk-in'), ('routine', 'Routine'), ('checkup', 'Check-up'), ('followup', 'Follow-up'), ('emergency', 'Emergency')], max_length=255), null=True, size=None)),
                ('start', models.DateTimeField(null=True)),
                ('end', models.DateTimeField(null=True)),
                ('overbooked', models.BooleanField(default=False)),
                ('comment', models.TextField(null=True)),
                ('status', models.CharField(choices=[('free', 'Free'), ('busy', 'Busy'), ('busy_unavailable', 'Busy Unavailable'), ('busy_tentative', 'Busy Tentative'), ('enter_in_error', 'Enter in Error')], default='free', max_length=255)),
                ('identifier', models.ManyToManyField(blank=True, related_name='slot_identifier', to='base.identifier')),
                ('practitioner', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='slot_practitioner', to='practitioners.practitioner')),
                ('schedule', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='slot_schedule', to='schedules.schedule')),
                ('service_category', models.ManyToManyField(blank=True, related_name='slot_service_category', to='base.codeableconcept')),
                ('service_type', models.ManyToManyField(blank=True, related_name='slot_service_type', to='healthcareservices.healthcareservicecodeablereference')),
                ('specialty', models.ManyToManyField(blank=True, related_name='slot_specialty', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
