# Generated by Django 4.2.14 on 2025-01-28 10:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('locations', '0004_locationcodeablereference'),
        ('provenances', '0001_initial'),
        ('patients', '0006_patientgroupreference_group_and_more'),
        ('groups', '0003_delete_groupspecimenreference'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('diagnosticreports', '0004_rename_media_diagnosticreportmedia_and_more'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('healthcareservices', '0005_remove_healthcareservicecodeablereference_healthcare_service'),
        ('devicedefinitions', '0001_initial'),
        ('base', '0008_alter_extendedcontactdetail_address_and_more'),
        ('devices', '0003_remove_devicemetriccalibration_state_and_more'),
        ('organizations', '0001_initial'),
        ('medications', '0004_medicationreference_medicationcodeablereference'),
        ('observations', '0006_alter_observation_instantiates_reference_and_more'),
        ('procedures', '0001_initial'),
        ('conditions', '0002_alter_conditioncodeablereference_concept_and_more'),
        ('bodystructures', '0001_initial'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('practitioners', '0008_practitionerpractitionerrolereference'),
        ('careplans', '0002_remove_careplan_goal_careplan_note'),
        ('servicerequests', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrderDetailParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_boolean', models.BooleanField(default=False)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_code', to='base.codeableconcept')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_value_codeable_concept', to='base.codeableconcept')),
                ('value_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_value_period', to='base.period')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_value_quantity', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_value_range', to='base.range')),
                ('value_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='order_detail_parameter_value_ratio', to='base.ratio')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrderDetailParameterFocusCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_codeable_reference_concept', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrderDetailParameterFocusReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_device', to='devices.device')),
                ('device_definition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_device_definition', to='devicedefinitions.devicedefinition')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_identifier', to='base.identifier')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_medication', to='medications.medication')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_medication_request', to='medicationrequests.medicationrequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestBasedOnReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_based_on_care_paln', to='careplans.careplan')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_based_on_identifier', to='base.identifier')),
                ('medicatoin_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_based_on_medication_request', to='medicationrequests.medicationrequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestOrderDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('parameter', models.ManyToManyField(blank=True, related_name='service_request_order_detail_parameter', to='servicerequests.orderdetailparameter')),
                ('parameter_focus', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_order_detail_parameter_focus', to='servicerequests.orderdetailparameterfocuscodeablereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestPatientInstruction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instruction_markdown', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_device', to='devices.device')),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_healthcare_service', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_performer_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestReasonCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_codeable_reference_concept', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestReasonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_condition', to='conditions.condition')),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestRequesterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject_location', to='locations.location')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject_patient', to='patients.patient')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='bodystructure',
            name='excluded_structure',
        ),
        migrations.RemoveField(
            model_name='bodystructure',
            name='included_structure',
        ),
        migrations.RemoveField(
            model_name='bodystructure',
            name='patient',
        ),
        migrations.RemoveField(
            model_name='bodystructure',
            name='service_request',
        ),
        migrations.RemoveField(
            model_name='includedstructure',
            name='body_landmark_orientation',
        ),
        migrations.RemoveField(
            model_name='orderdetail',
            name='parameter',
        ),
        migrations.RemoveField(
            model_name='orderdetail',
            name='service_request',
        ),
        migrations.RenameField(
            model_name='servicerequest',
            old_name='end_date_time',
            new_name='authored_on',
        ),
        migrations.RenameField(
            model_name='servicerequest',
            old_name='start_date_time',
            new_name='occurrence_date_time',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='as_needed',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='as_needed_boolean',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='code',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='encounter',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='instantiates_canonical',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='insurance',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='patient',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='practitioner',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='specimen',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='timing',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='value',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='value_range',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='value_ratio',
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='as_needed_for',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_as_needed_for', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='body_structure',
            field=models.ManyToManyField(blank=True, related_name='service_request_body_structure', to='bodystructures.bodystructurereference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='focus',
            field=models.ManyToManyField(blank=True, related_name='service_request_focus', to='servicerequests.reference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='service_request_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='occurrence_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_occurrence_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='occurrence_timing',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_occurrence_timing', to='base.timing'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='performer_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='quantity_quantity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_quantity_quantity', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='quantity_range',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_quantity_range', to='base.range'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='quantity_ratio',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_quantity_ratio', to='base.ratio'),
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='based_on',
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='body_site',
            field=models.ManyToManyField(blank=True, related_name='service_request_body_site', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='category',
            field=models.ManyToManyField(blank=True, related_name='service_request_category', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='instantiates_uri',
            field=models.URLField(null=True),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='intent',
            field=models.CharField(choices=[('proposal', 'Proposal'), ('plan', 'Plan'), ('order', 'Order'), ('original_order', 'Original Order'), ('reflex_order', 'Reflex Order'), ('filler_order', 'Filler Order'), ('instance_order', 'Instance Order'), ('option', 'Option')], default='order', max_length=255),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='location',
            field=models.ManyToManyField(blank=True, related_name='service_request_location', to='locations.locationcodeablereference'),
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='note',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='patient_instruction',
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='priority',
            field=models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('asap', 'ASAP'), ('stat', 'Stat')], default='routine', max_length=255),
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='relevant_history',
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='replaces',
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='requisition',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requisition', to='base.identifier'),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('active', 'Active'), ('on_hold', 'On Hold'), ('revoked', 'Revoked'), ('completed', 'Completed'), ('entered_in_error', 'Entered in Error'), ('unknown', 'Unknown')], default='active', max_length=255),
        ),
        migrations.RemoveField(
            model_name='servicerequest',
            name='supporting_info',
        ),
        migrations.DeleteModel(
            name='BodyLandmarkOrientation',
        ),
        migrations.DeleteModel(
            name='BodyStructure',
        ),
        migrations.DeleteModel(
            name='IncludedStructure',
        ),
        migrations.DeleteModel(
            name='OrderDetail',
        ),
        migrations.AddField(
            model_name='servicerequestreference',
            name='service_request',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reference_service_request', to='servicerequests.servicerequest'),
        ),
        migrations.AddField(
            model_name='servicerequestreasoncodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_reason_codeable_reference_reference', to='servicerequests.servicerequestreasonreference'),
        ),
        migrations.AddField(
            model_name='servicerequestbasedonreference',
            name='service_request',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_based_on_service_request', to='servicerequests.servicerequest'),
        ),
        migrations.AddField(
            model_name='orderdetailparameterfocuscodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='order_detail_parameter_focus_codeable_reference_reference', to='servicerequests.orderdetailparameterfocusreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='additional_recipient',
            field=models.ManyToManyField(blank=True, related_name='service_request_additional_recipient', to='servicerequests.servicerequestrequesterreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='order_detail',
            field=models.ManyToManyField(blank=True, to='servicerequests.servicerequestorderdetail'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='performer',
            field=models.ManyToManyField(blank=True, related_name='service_request_performer', to='servicerequests.servicerequestperformerreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='requester',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_requester', to='servicerequests.servicerequestrequesterreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='service_request_subject', to='servicerequests.servicerequestsubjectreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='based_on',
            field=models.ManyToManyField(blank=True, related_name='service_request_based_on', to='servicerequests.servicerequestbasedonreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='service_request_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='patient_instruction',
            field=models.ManyToManyField(blank=True, related_name='service_request_patient_instruction', to='servicerequests.servicerequestpatientinstruction'),
        ),
        migrations.AlterField(
            model_name='servicerequest',
            name='reason',
            field=models.ManyToManyField(blank=True, related_name='service_request_reason', to='servicerequests.servicerequestreasoncodeablereference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='relevant_history',
            field=models.ManyToManyField(blank=True, related_name='service_request_relevant_history', to='provenances.provenancereference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='replaces',
            field=models.ManyToManyField(blank=True, related_name='service_request_replaces', to='servicerequests.servicerequestreference'),
        ),
        migrations.AddField(
            model_name='servicerequest',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='service_request_supporting_info', to='base.codeablereference'),
        ),
    ]
