# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('locations', '0001_initial'),
        ('patients', '0001_initial'),
        ('practitioners', '0001_initial'),
        ('encounters', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AsNeeded',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BodyLandmarkOrientation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('landmark_description', models.CharField(max_length=255, null=True)),
                ('clock_face_position', models.CharField(max_length=255, null=True)),
                ('surface_orientation', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BodySite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProcedureCodes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProcedureReason',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Reference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequestCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instantiates_uri', models.CharField(max_length=255, null=True)),
                ('requisition', models.CharField(max_length=255, null=True)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('active', 'Active'), ('on_hold', 'On Hold'), ('revoked', 'Revoked'), ('completed', 'Completed'), ('entered_in_error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('intent', models.CharField(choices=[('proposal', 'Proposal'), ('plan', 'Plan'), ('order', 'Order'), ('original_order', 'Original Order'), ('reflex_order', 'Reflex Order'), ('filler_order', 'Filler Order'), ('instance_order', 'Instance Order'), ('option', 'Option')], max_length=255, null=True)),
                ('priority', models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('asap', 'ASAP'), ('stat', 'Stat')], max_length=50, null=True)),
                ('do_not_perform', models.BooleanField(default=False)),
                ('supporting_info', models.CharField(max_length=255, null=True)),
                ('note', models.TextField(null=True)),
                ('patient_instruction', models.TextField(null=True)),
                ('as_needed_boolean', models.BooleanField(default=False)),
                ('value', models.DecimalField(decimal_places=2, max_digits=255, null=True)),
                ('value_ratio', models.CharField(max_length=255, null=True)),
                ('value_range', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(blank=True, choices=[('catheter_insertion', 'Catheter Insertion'), ('body_elevation', 'Body Elevation'), ('device_configuration', 'Device Configuration'), ('device_settings', 'Device Settings')], max_length=255, null=True)),
                ('timing', models.CharField(max_length=255, null=True)),
                ('start_date_time', models.DateTimeField(null=True)),
                ('end_date_time', models.DateTimeField(null=True)),
                ('instantiates_canonical', models.CharField(blank=True, max_length=255, null=True)),
                ('insurance', models.CharField(max_length=255, null=True)),
                ('specimen', models.CharField(max_length=255, null=True)),
                ('relevant_history', models.CharField(max_length=255, null=True)),
                ('replaces', models.CharField(max_length=255, null=True)),
                ('as_needed', models.OneToOneField(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='servicerequests.asneeded')),
                ('based_on', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='servicerequests.servicerequest')),
                ('body_site', models.ManyToManyField(related_name='service_request_body_site', to='servicerequests.bodysite')),
                ('category', models.ManyToManyField(related_name='service_requests', to='servicerequests.servicerequestcategory')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='service_request_encounter', to='encounters.encounter')),
                ('location', models.ManyToManyField(blank=True, related_name='service_request_location', to='locations.location')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='service_request_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='service_request_practitioner', to='practitioners.practitioner')),
                ('reason', models.ManyToManyField(related_name='service_request_reason', to='servicerequests.procedurereason')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrderDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('parameter_focus', models.CharField(max_length=255)),
                ('parameter', models.ManyToManyField(related_name='orderDetail_parameter', to='servicerequests.parameter')),
                ('service_request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='order_detail', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='IncludedStructure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('structure', models.JSONField()),
                ('laterality', models.JSONField(blank=True, null=True)),
                ('spatial_reference', models.JSONField(blank=True, null=True)),
                ('qualifier', models.JSONField(blank=True, null=True)),
                ('body_landmark_orientation', models.ManyToManyField(blank=True, to='servicerequests.bodylandmarkorientation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BodyStructure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('morphology', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='body_structures')),
                ('excluded_structure', models.ManyToManyField(blank=True, related_name='excluded_in', to='servicerequests.includedstructure')),
                ('included_structure', models.ManyToManyField(blank=True, related_name='included_in', to='servicerequests.includedstructure')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='patient_body_structure', to='patients.patient')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='service_request_body_structure', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
