# Generated by Django 4.2.14 on 2025-02-06 11:06

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('biologicallyderivedproducts', '0001_initial'),
        ('conditions', '0002_alter_conditioncodeablereference_concept_and_more'),
        ('procedures', '0002_procedurebasedonreference_procedurefocaldevice_and_more'),
        ('organizations', '0003_organization_endpoint'),
        ('patients', '0007_patientorganizationreference'),
        ('medications', '0004_medicationreference_medicationcodeablereference'),
        ('observations', '0007_observationcodeablereference_delete_bodysite_and_more'),
        ('healthcareservices', '0006_remove_healthcareservice_endpoint'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('diagnosticreports', '0005_diagnosticreportdocumentreferencereference'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('substances', '0002_substancecodeablereference'),
        ('careplans', '0002_remove_careplan_goal_careplan_note'),
        ('medicationadministrations', '0004_medicationadministration_based_on_and_more'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('servicerequests', '0005_servicerequestplandefinitionreference_and_more'),
        ('devices', '0007_alter_device_status_and_more'),
        ('locations', '0006_merge_20250129_1542'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('base', '0010_expression_relativetime'),
    ]

    operations = [
        migrations.AddField(
            model_name='procedure',
            name='follow_up',
            field=models.ManyToManyField(blank=True, related_name='procedure_follow_up', to='servicerequests.servicerequestplandefinitionreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='procedure_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='occurrence_date_time',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='procedure',
            name='occurrence_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_occurrence_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='occurrence_range',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_occurrence_range', to='base.range'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='occurrence_string',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='procedure',
            name='occurrence_timing',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_occurrence_timing', to='base.timing'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='outcome',
            field=models.ManyToManyField(blank=True, related_name='procedure_outcome', to='observations.observationcodeablereference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='recorded',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='procedure',
            name='report',
            field=models.ManyToManyField(blank=True, related_name='procedure_report', to='diagnosticreports.diagnosticreportdocumentreferencereference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='reported_boolean',
            field=models.BooleanField(null=True),
        ),
        migrations.AddField(
            model_name='procedure',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='procedure_supporting_info', to='base.reference'),
        ),
        migrations.AlterField(
            model_name='procedure',
            name='status',
            field=models.CharField(choices=[('preparation', 'Preparation'), ('in-progress', 'In Progress'), ('not-done', 'Not Done'), ('on-hold', 'On Hold'), ('stopped', 'Stopped'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='procedureusedreference',
            name='biologically_derived_product',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_reference_biologically_derived_product', to='biologicallyderivedproducts.biologicallyderivedproduct'),
        ),
        migrations.AddField(
            model_name='procedureusedreference',
            name='device',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_reference_device', to='devices.device'),
        ),
        migrations.AddField(
            model_name='procedureusedreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedureusedreference',
            name='medication',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_reference_medication', to='medications.medication'),
        ),
        migrations.AddField(
            model_name='procedureusedreference',
            name='substance',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_reference_substance', to='substances.substance'),
        ),
        migrations.AddField(
            model_name='procedureusedcodeablereference',
            name='concept',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_concept', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='procedureusedcodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_used_codeable_reference', to='procedures.procedureusedreference'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='device',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_device', to='devices.device'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_group', to='groups.group'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='location',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_location', to='locations.location'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='organization',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_organization', to='organizations.organization'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_patient', to='patients.patient'),
        ),
        migrations.AddField(
            model_name='proceduresubjectreference',
            name='practitioner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject_reference_practitioner', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='procedurereportedreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurereportedreference',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference_patient', to='patients.patient'),
        ),
        migrations.AddField(
            model_name='procedurereportedreference',
            name='practitioner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference_practitioner', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='procedurereportedreference',
            name='practitioner_role',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference_practitioner_role', to='practitioners.practitionerrole'),
        ),
        migrations.AddField(
            model_name='procedurereportedreference',
            name='related_person',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference_related_person', to='relatedpersons.relatedperson'),
        ),
        migrations.AddField(
            model_name='procedurerecorderreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurerecorderreference',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder_reference_patient', to='patients.patient'),
        ),
        migrations.AddField(
            model_name='procedurerecorderreference',
            name='practitioner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder_reference_practitioner', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='procedurerecorderreference',
            name='practitioner_role',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder_reference_practitioner_role', to='practitioners.practitionerrole'),
        ),
        migrations.AddField(
            model_name='procedurerecorderreference',
            name='related_person',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder_reference_related_person', to='relatedpersons.relatedperson'),
        ),
        migrations.AddField(
            model_name='procedurereasonreference',
            name='condition',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_reference_condition', to='conditions.condition'),
        ),
        migrations.AddField(
            model_name='procedurereasonreference',
            name='diagnostic_report',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_reference_diagnostic_report', to='diagnosticreports.diagnosticreport'),
        ),
        migrations.AddField(
            model_name='procedurereasonreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurereasonreference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_reference_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='procedurereasonreference',
            name='procedure',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_reference_procedure', to='procedures.procedure'),
        ),
        migrations.AddField(
            model_name='procedurereasoncodeablereference',
            name='concept',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_concept', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='procedurereasoncodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reason_codeable_reference', to='procedures.procedurereasonreference'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='care_team',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_care_team', to='careteams.careteam'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='device',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_device', to='devices.device'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='healthcare_service',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_healthcare_service', to='healthcareservices.healthcareservice'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='organization',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_organization', to='organizations.organization'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_patient', to='patients.patient'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='practitioner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_practitioner', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='practitioner_role',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_practitioner_role', to='practitioners.practitionerrole'),
        ),
        migrations.AddField(
            model_name='procedureperformeractorreference',
            name='related_person',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor_reference_related_person', to='relatedpersons.relatedperson'),
        ),
        migrations.AddField(
            model_name='procedureperformer',
            name='actor',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_actor', to='procedures.procedureperformeractorreference'),
        ),
        migrations.AddField(
            model_name='procedureperformer',
            name='function',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_function', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='procedureperformer',
            name='on_behalf_of',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_on_behalf_of', to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='procedureperformer',
            name='period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_performer_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='procedurepartofreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_partof_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurepartofreference',
            name='medication_administration',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_partof_reference_medication_administration', to='medicationadministrations.medicationadministration'),
        ),
        migrations.AddField(
            model_name='procedurepartofreference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_partof_reference_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='procedurepartofreference',
            name='procedure',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_partof_reference_procedure', to='procedures.procedure'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='care_team',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_care_team', to='careteams.careteam'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_group', to='groups.group'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='organization',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_organization', to='organizations.organization'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_patient', to='patients.patient'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='practitioner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_practitioner', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='practitioner_role',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_practitioner_role', to='practitioners.practitionerrole'),
        ),
        migrations.AddField(
            model_name='procedurefocusreference',
            name='related_person',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus_reference_related_person', to='relatedpersons.relatedperson'),
        ),
        migrations.AddField(
            model_name='procedurefocaldevice',
            name='action',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focal_device_action', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='procedurefocaldevice',
            name='manipulated',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focal_device_manipulated', to='devices.devicereference'),
        ),
        migrations.AddField(
            model_name='procedurebasedonreference',
            name='care_plan',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_based_on_reference_care_plan', to='careplans.careplan'),
        ),
        migrations.AddField(
            model_name='procedurebasedonreference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_based_on_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='procedurebasedonreference',
            name='medication_request',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_based_on_reference_medication_request', to='medicationrequests.medicationrequest'),
        ),
        migrations.AddField(
            model_name='procedurebasedonreference',
            name='service_request',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_based_on_reference_service_request', to='servicerequests.servicerequest'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='based_on',
            field=models.ManyToManyField(blank=True, related_name='procedure_based_on', to='procedures.procedurebasedonreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='focal_device',
            field=models.ManyToManyField(blank=True, related_name='procedure_focal_device', to='procedures.procedurefocaldevice'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='focus',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_focus', to='procedures.procedurefocusreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='part_of',
            field=models.ManyToManyField(blank=True, related_name='procedure_part_of', to='procedures.procedurepartofreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='performer',
            field=models.ManyToManyField(blank=True, related_name='procedure_performer', to='procedures.procedureperformer'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='reason',
            field=models.ManyToManyField(blank=True, related_name='procedure_reason', to='procedures.procedurereasoncodeablereference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='recorder',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_recorder', to='procedures.procedurerecorderreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='reported_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_reported_reference', to='procedures.procedurereportedreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='procedure_subject', to='procedures.proceduresubjectreference'),
        ),
        migrations.AddField(
            model_name='procedure',
            name='used',
            field=models.ManyToManyField(blank=True, related_name='procedure_used', to='procedures.procedureusedreference'),
        ),
    ]
