# Generated by Django 4.2.14 on 2025-01-06 22:48

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('organizations', '0001_initial'),
        ('locations', '0001_initial'),
        ('healthcareservices', '0001_initial'),
        ('base', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Communication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('language', models.CharField(max_length=100, null=True, verbose_name='language spoken')),
                ('preferred', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GeneralPractitionerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='Practitioner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('first_name', models.CharField(blank=True, max_length=255, null=True)),
                ('last_name', models.CharField(blank=True, max_length=255, null=True)),
                ('middle_name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='email address')),
                ('gender', models.CharField(blank=True, choices=[('male', 'male'), ('female', 'female'), ('other', 'other'), ('unknown', 'unknown')], max_length=20, null=True)),
                ('date_of_birth', models.DateTimeField(blank=True, null=True)),
                ('deceased', models.BooleanField(default=False)),
                ('deceased_date_time', models.DateTimeField(blank=True, null=True)),
                ('active', models.BooleanField(default=True)),
                ('address', models.ManyToManyField(blank=True, related_name='practitioner_address', to='base.address')),
                ('qualification', models.ManyToManyField(blank=True, related_name='practitioner_qualification', to='base.qualification')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerRole',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('period', models.CharField(blank=True, max_length=50, null=True)),
                ('characteristic', models.CharField(blank=True, choices=[('in_person', 'in-person'), ('telephone', 'telephone'), ('video_conference', 'video-conference'), ('chat', 'chat')], max_length=50, null=True)),
                ('availability', models.ManyToManyField(blank=True, related_name='practitioner_role_availability', to='base.availability')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerRoleCode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255)),
                ('definition', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerRoleContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('purpose', models.CharField(blank=True, max_length=255, null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('period', models.CharField(blank=True, max_length=255, null=True)),
                ('organization', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='practitioner_role_contact_organization', to='organizations.organization')),
                ('practitioner_role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='practitioner_role_contact', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerTelecom',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(blank=True, max_length=17, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('use', models.CharField(choices=[('home', 'home'), ('work', 'work'), ('temp', 'temp'), ('old', 'old'), ('mobile', 'mobile')], default='mobile', max_length=10)),
                ('practitioner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='practitioner_telecom', to='practitioners.practitioner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerRoleContactTelecom',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(blank=True, max_length=17, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('use', models.CharField(choices=[('home', 'home'), ('work', 'work'), ('temp', 'temp'), ('old', 'old'), ('mobile', 'mobile')], default='mobile', max_length=10)),
                ('practitioner_role_contact', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='practitioner_role_contact_telecom', to='practitioners.practitionerrolecontact')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PractitionerRoleCommunication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('language', models.CharField(max_length=100, null=True, verbose_name='language spoken')),
                ('preferred', models.BooleanField(default=False)),
                ('practitioner_role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='practitioner_role_communication', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='code',
            field=models.ManyToManyField(related_name='practitioner_role_code', to='practitioners.practitionerrolecode'),
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='health_care_service',
            field=models.ManyToManyField(related_name='practitioner_role_healthcareservice', to='healthcareservices.healthcareservice'),
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='location',
            field=models.ManyToManyField(related_name='practitioner_role_location', to='locations.location'),
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='organization',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='practitioner_role_organization', to='organizations.organization'),
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='practitioner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='practitioner_role', to='practitioners.practitioner'),
        ),
        migrations.AddField(
            model_name='practitionerrole',
            name='specialty',
            field=models.ManyToManyField(related_name='practitioner_role_specialty', to='healthcareservices.clinicalspecialty'),
        ),
    ]
