# Generated by Django 4.2.14 on 2025-03-19 12:20

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('devices', '0007_alter_device_status_and_more'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('devicedefinitions', '0002_devicedefinitiondeviceversion_and_more'),
        ('base', '0020_triggerdefinition_timing_reference_and_more'),
        ('locations', '0006_merge_20250129_1542'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('practitioners', '0011_practitionerrolereference'),
        ('organizations', '0004_organizationcodeablereference'),
        ('patients', '0007_patientorganizationreference'),
        ('endpoints', '0006_alter_endpoint_connection_type'),
        ('healthcareservices', '0006_remove_healthcareservice_endpoint'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlanDefinitionActionInput',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('related_data', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActionOutput',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('related_data', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActorOptionTypeReferenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_device', to='devices.device')),
                ('device_definition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_device_definition', to='devicedefinitions.devicedefinition')),
                ('endpoint', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_endpoint', to='endpoints.endpoint')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_group', to='groups.group')),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_healthcare_service', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_location', to='locations.location')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_actor_option_type_reference_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefintionActorOption',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('care-team', 'Care Team'), ('device', 'Device'), ('group', 'Group'), ('healthcareservice', 'Healthcare Service'), ('location', 'Location'), ('organization', 'Organization'), ('patient', 'Patient'), ('practitioner', 'Practitioner'), ('practitionerrole', 'Practitioner Role'), ('relatedperson', 'Related Person')], default='patient', max_length=255)),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_actor_option_role', to='base.codeableconcept')),
                ('type_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_actor_option_type_reference', to='plandefinitions.plandefinitionactoroptiontypereferencereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='plan_definition_subject_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionGoalTarget',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('detail_string', models.CharField(max_length=255, null=True)),
                ('detail_boolean', models.BooleanField(null=True)),
                ('detail_integer', models.IntegerField(null=True)),
                ('detail_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_detail_codeable_concept', to='base.codeableconcept')),
                ('detail_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_detail_quantity', to='base.quantity')),
                ('detail_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_detail_range', to='base.range')),
                ('detail_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_detail_ratio', to='base.ratio')),
                ('due', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_due', to='base.period')),
                ('measure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_target_measure', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionGoal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('addresses', models.ManyToManyField(related_name='plan_definition_goal_addresses', to='base.codeableconcept')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_category', to='base.codeableconcept')),
                ('description', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_description', to='base.codeableconcept')),
                ('documentation', models.ManyToManyField(related_name='plan_definition_goal_documentation', to='base.relatedartifact')),
                ('priority', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_priority', to='base.codeableconcept')),
                ('start', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_goal_start', to='base.codeableconcept')),
                ('target', models.ManyToManyField(related_name='plan_definition_goal_target', to='plandefinitions.plandefinitiongoaltarget')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('description', models.CharField(max_length=255, null=True)),
                ('option', models.ManyToManyField(related_name='plan_definition_actor_option', to='plandefinitions.plandefintionactoroption')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActionRelatedAction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('target_id', models.CharField(max_length=255, null=True)),
                ('relationship', models.CharField(choices=[('before-start', 'Before Start'), ('before', 'Before'), ('before-end', 'Before End'), ('concurrent-with-start', 'Concurrent with Start'), ('concurrent', 'Concurrent'), ('concurrent-with-end', 'Concurrent with End'), ('after-start', 'After Start'), ('after', 'After'), ('after-end', 'After End')], default='before-start', max_length=255)),
                ('end_relationship', models.CharField(choices=[('before-start', 'Before Start'), ('before', 'Before'), ('before-end', 'Before End'), ('concurrent-with-start', 'Concurrent with Start'), ('concurrent', 'Concurrent'), ('concurrent-with-end', 'Concurrent with End'), ('after-start', 'After Start'), ('after', 'After'), ('after-end', 'After End')], default='before-start', max_length=255)),
                ('offset_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_related_action_offset_duration', to='base.duration')),
                ('offset_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_related_action_offset_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActionParticipant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('care-team', 'Care Team'), ('device', 'Device'), ('group', 'Group'), ('healthcareservice', 'Healthcare Service'), ('location', 'Location'), ('organization', 'Organization'), ('patient', 'Patient'), ('practitioner', 'Practitioner'), ('practitionerrole', 'Practitioner Role'), ('relatedperson', 'Related Person')], default='patient', max_length=255)),
                ('function', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_participant_function', to='base.codeableconcept')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_participant_role', to='base.codeableconcept')),
                ('type_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_participant_type_reference', to='plandefinitions.plandefinitionactoroptiontypereferencereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActionDynamicValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('path', models.CharField(max_length=255, null=True)),
                ('expression', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_dynamic_value_expression', to='base.expression')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionActionCondition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('kind', models.CharField(choices=[('applicability', 'Applicability'), ('start', 'Start'), ('stop', 'Stop')], default='applicability', max_length=255)),
                ('expression', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_condition_expression', to='base.expression')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinitionAction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('link_id', models.CharField(max_length=255, null=True)),
                ('prefix', models.CharField(max_length=255, null=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('description', models.CharField(max_length=255, null=True)),
                ('text_equivalent', models.CharField(max_length=255, null=True)),
                ('priority', models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('asap', 'As soon as possible'), ('stat', 'Stat')], default='routine', max_length=255)),
                ('goal_id', models.CharField(max_length=255, null=True)),
                ('grouping_behavior', models.CharField(choices=[('visual-group', 'Visual Group'), ('logical-group', 'Logical Group'), ('sentence-group', 'Sentence Group')], default='logical-group', max_length=255)),
                ('selection_behavior', models.CharField(choices=[('any', 'Any'), ('all', 'All'), ('all-or-none', 'All or None'), ('exactly-one', 'Exactly One'), ('at-most-one', 'At Most One'), ('one-or-more', 'One or More')], default='all', max_length=255)),
                ('required_behavior', models.CharField(choices=[('must', 'Must'), ('could', 'Could'), ('must-unless-documented', 'Must unless Documented')], default='must', max_length=255)),
                ('precheck_behavior', models.CharField(choices=[('yes', 'Yes'), ('no', 'No')], default='yes', max_length=255)),
                ('cardinality_behavior', models.CharField(choices=[('single', 'Single'), ('multiple', 'Multiple')], default='single', max_length=255)),
                ('definition_uri', models.CharField(max_length=255, null=True)),
                ('action', models.ManyToManyField(blank=True, related_name='plan_definition_action_action', to='plandefinitions.plandefinitionaction')),
                ('code', models.ManyToManyField(related_name='plan_definition_action_code', to='base.codeableconcept')),
                ('condition', models.ManyToManyField(related_name='plan_definition_action_condition', to='plandefinitions.plandefinitionactioncondition')),
                ('documentation', models.ManyToManyField(related_name='plan_definition_action_documentation', to='base.relatedartifact')),
                ('dynamic_value', models.ManyToManyField(blank=True, related_name='plan_definition_action_dynamic_value', to='plandefinitions.plandefinitionactiondynamicvalue')),
                ('input', models.ManyToManyField(blank=True, related_name='plan_definition_action_input', to='plandefinitions.plandefinitionactioninput')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_location', to='locations.locationcodeablereference')),
                ('output', models.ManyToManyField(blank=True, related_name='plan_definition_action_output', to='plandefinitions.plandefinitionactionoutput')),
                ('participant', models.ManyToManyField(blank=True, related_name='plan_definition_action_participant', to='plandefinitions.plandefinitionactionparticipant')),
                ('reason', models.ManyToManyField(related_name='plan_definition_action_reason', to='base.codeableconcept')),
                ('related_action', models.ManyToManyField(blank=True, related_name='plan_definition_action_related_action', to='plandefinitions.plandefinitionactionrelatedaction')),
                ('subject_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_subject_codeable_concept', to='base.codeableconcept')),
                ('subject_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_subject_reference', to='groups.groupreference')),
                ('timing_age', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_timing_age', to='base.age')),
                ('timing_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_timing_duration', to='base.duration')),
                ('timing_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_timing_range', to='base.range')),
                ('timing_timing', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_timing_timing', to='base.timing')),
                ('trigger', models.ManyToManyField(blank=True, related_name='plan_definition_action_trigger', to='base.triggerdefinition')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_action_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlanDefinition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('url', models.URLField(null=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('version_algorithm_string', models.CharField(max_length=255, null=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('subtitle', models.CharField(max_length=255, null=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('draft', 'Draft'), ('retired', 'Retired'), ('unknown', 'Unknown')], default='active', max_length=255)),
                ('experimental', models.BooleanField(default=False)),
                ('date', models.DateTimeField(null=True)),
                ('publisher', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
                ('purpose', models.TextField(null=True)),
                ('usage', models.TextField(null=True)),
                ('copyright', models.CharField(max_length=255, null=True)),
                ('copyright_label', models.CharField(max_length=255, null=True)),
                ('approval_date', models.DateTimeField(null=True)),
                ('last_review_date', models.DateTimeField(null=True)),
                ('as_needed_boolean', models.BooleanField(null=True)),
                ('action', models.ManyToManyField(blank=True, related_name='plan_definition_action', to='plandefinitions.plandefinitionaction')),
                ('actor', models.ManyToManyField(blank=True, related_name='plan_definition_actor', to='plandefinitions.plandefinitionactor')),
                ('as_needed_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_as_needed_codeable_concept', to='base.codeableconcept')),
                ('author', models.ManyToManyField(blank=True, related_name='plan_definition_author', to='base.contactdetail')),
                ('contact', models.ManyToManyField(blank=True, related_name='plan_definition_contact', to='base.contactdetail')),
                ('editor', models.ManyToManyField(blank=True, related_name='plan_definition_editor', to='base.contactdetail')),
                ('effective_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_effective_period', to='base.period')),
                ('endorser', models.ManyToManyField(blank=True, related_name='plan_definition_endorser', to='base.contactdetail')),
                ('goal', models.ManyToManyField(blank=True, related_name='plan_definition_goal', to='plandefinitions.plandefinitiongoal')),
                ('identifier', models.ManyToManyField(blank=True, related_name='plan_definition_identifier', to='base.identifier')),
                ('jurisdiction', models.ManyToManyField(blank=True, related_name='plan_definition_jurisdiction', to='base.codeableconcept')),
                ('related_artifact', models.ManyToManyField(blank=True, related_name='plan_definition_related_artifact', to='base.relatedartifact')),
                ('reviewer', models.ManyToManyField(blank=True, related_name='plan_definition_reviewer', to='base.contactdetail')),
                ('subject_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_subject_codeable_concept', to='base.codeableconcept')),
                ('subject_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_subject_reference', to='plandefinitions.plandefinitionsubjectreference')),
                ('topic', models.ManyToManyField(blank=True, related_name='plan_definition_topic', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_type', to='base.codeableconcept')),
                ('use_context', models.ManyToManyField(blank=True, related_name='plan_definition_use_context', to='base.usagecontext')),
                ('version_algorithm_coding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='plan_definition_version_algorithm_coding', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
