# Generated by Django 4.2.14 on 2025-02-28 14:29

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("organizations", "0003_organization_endpoint"),
        ("locations", "0006_merge_20250129_1542"),
        ("base", "0013_money"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("patients", "0007_patientorganizationreference"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("accounts", "0007_account_billing_status_account_currency"),
    ]

    operations = [
        migrations.CreateModel(
            name="OrganizationPractitionerPractitionerRoleReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="organization_practitioner_practitioner_role_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="organization_practitioner_practitioner_role_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="organization_practitioner_practitioner_role_reference_patient",
                        to="patients.patientreference",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="organization_practitioner_practitioner_role_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("cancelled", "Cancelled"),
                            ("draft", "Draft"),
                            ("entered-in-error", "Entered in Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("created", models.DateTimeField(null=True)),
                (
                    "outcome",
                    models.CharField(
                        choices=[
                            ("queued", "Queued"),
                            ("complete", "Complete"),
                            ("error", "Error"),
                            ("partial", "Partial"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("disposition", models.CharField(max_length=255, null=True)),
                ("date", models.DateField(null=True)),
                ("card_brand", models.CharField(max_length=255, null=True)),
                ("account_number", models.CharField(max_length=255, null=True)),
                ("expiration_date", models.DateField(null=True)),
                ("processor", models.CharField(max_length=255, null=True)),
                ("reference_number", models.CharField(max_length=255, null=True)),
                ("authorization", models.DateField(null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliationProcessNote",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("display", "Display"),
                            ("print", "Print"),
                            ("printoper", "Print Oper"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("text", models.CharField(max_length=255, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliationReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "payment_reconciliation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_reference_payment_reconciliation",
                        to="paymentreconciliations.paymentreconciliation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliationPaymentIssuerReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_reconciliation_payment_issuer_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_payment_issuer_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_payment_issuer_reference_patient",
                        to="patients.patientreference",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_payment_issuer_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliationAllocationTargetReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "account",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_target_reference_account",
                        to="accounts.account",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_target_reference_encounter",
                        to="encounters.encounter",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentReconciliationAllocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("target_item_string", models.CharField(max_length=255, null=True)),
                ("target_item_positive_int", models.IntegerField(null=True)),
                (
                    "account",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_account",
                        to="accounts.accountreference",
                    ),
                ),
                (
                    "amount",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_amount",
                        to="base.money",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "payee",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_payee",
                        to="paymentreconciliations.organizationpractitionerpractitionerrolereference",
                    ),
                ),
                (
                    "predecessor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_predecessor",
                        to="base.identifier",
                    ),
                ),
                (
                    "submitter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_submitter",
                        to="paymentreconciliations.organizationpractitionerpractitionerrolereference",
                    ),
                ),
                (
                    "target",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_target",
                        to="paymentreconciliations.organizationpractitionerpractitionerrolereference",
                    ),
                ),
                (
                    "target_item_identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_target_item_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="payment_reconciliation_allocation_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="allocation",
            field=models.ManyToManyField(
                blank=True,
                related_name="payment_reconciliation_allocation",
                to="paymentreconciliations.paymentreconciliationallocation",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="amount",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_amount",
                to="base.money",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="enterer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_enterer",
                to="paymentreconciliations.organizationpractitionerpractitionerrolereference",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="payment_reconciliation_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="issued_by",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_issued_by",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="kind",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_kind",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="method",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_method",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="payment_identifier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_payment_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="payment_issuer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_payment_issuer",
                to="paymentreconciliations.paymentreconciliationpaymentissuerreference",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="process_note",
            field=models.ManyToManyField(
                blank=True,
                related_name="payment_reconciliation_process_note",
                to="paymentreconciliations.paymentreconciliationprocessnote",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="requestor",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_requestor",
                to="paymentreconciliations.organizationpractitionerpractitionerrolereference",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="returned_amount",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_returned_amount",
                to="base.money",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="tendered_amount",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_tendered_amount",
                to="base.money",
            ),
        ),
        migrations.AddField(
            model_name="paymentreconciliation",
            name="type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="payment_reconciliation_type",
                to="base.codeableconcept",
            ),
        ),
    ]
