# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('birth_date', models.DateField(blank=True, null=True)),
                ('gender', models.CharField(blank=True, choices=[('male', 'male'), ('female', 'female'), ('other', 'other'), ('unknown', 'unknown')], max_length=20, null=True)),
                ('middle_name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(max_length=254, null=True, unique=True, verbose_name='email address')),
                ('deceased_boolean', models.BooleanField(default=True)),
                ('deceased_date_time', models.DateTimeField(blank=True, null=True)),
                ('active', models.BooleanField(default=True)),
                ('multiple_birth_boolean', models.BooleanField(default=False)),
                ('multiple_birth_integer', models.IntegerField(blank=True, null=True)),
                ('address', models.ManyToManyField(blank=True, related_name='patient_address', to='base.address')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PatientRelatedPersonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_related_person_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_related_person_reference_patient', to='patients.patient')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PatientLink',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(blank=True, choices=[('replaced_by', 'replaced-by'), ('replaces', 'replaces'), ('refer', 'refer'), ('seealso', 'seealso')], max_length=20, null=True)),
                ('other', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_link_other', to='patients.patientrelatedpersonreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PatientContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('gender', models.CharField(blank=True, choices=[('male', 'male'), ('female', 'female'), ('other', 'other'), ('unknown', 'unknown')], max_length=20, null=True)),
                ('address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_contact_address', to='base.address')),
                ('name', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_contact_name', to='base.humanname')),
                ('organization', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='patient_contact_organization', to='base.organizationreference')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_contact_period', to='base.period')),
                ('relationship', models.ManyToManyField(blank=True, related_name='patient_contact_relationship', to='base.codeableconcept')),
                ('telecom', models.ManyToManyField(blank=True, related_name='patient_contact_telecom', to='base.contactpoint')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PatientCommunication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('preferred', models.BooleanField(default=False)),
                ('language', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_communication_language', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='patient',
            name='communication',
            field=models.ManyToManyField(blank=True, related_name='patient_communication', to='patients.patientcommunication'),
        ),
        migrations.AddField(
            model_name='patient',
            name='contact',
            field=models.ManyToManyField(blank=True, related_name='patient_contact', to='patients.patientcontact'),
        ),
    ]
