# Generated by Django 4.2.14 on 2025-01-14 19:06

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('locations', '0003_alter_locationorganizationreference_location_and_more'),
        ('medications', '0003_remove_ratio_denominator_remove_ratio_numerator_and_more'),
        ('patients', '0004_patientgroupreference'),
        ('servicerequests', '0001_initial'),
        ('encounters', '0008_alter_encounterlocation_location'),
        ('practitioners', '0007_remove_practitionerrole_availability_and_more'),
        ('organizations', '0001_initial'),
        ('medicationrequests', '0002_initial'),
        ('base', '0004_ratio'),
        ('observations', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ObservationBasedOnReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_based_on_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_based_on_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_based_on_reference_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationBodyStructureReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('body_structure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_body_structure_reference_body_structure', to='servicerequests.bodystructure')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_body_structure_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationDefinitionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_definition_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationDerivedFromReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_derived_from_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationDeviceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_device_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationHasMemberReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_has_member_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationMolecularSequenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='molecular_sequence_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationPartOfReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_part_of_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_performer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_performer_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationSpecimenReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_specimen_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='locations.location')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='medications.medication')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='practitioners.practitioner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SampledData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('interval', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('lower_limit', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('upper_limit', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('dimensions', models.IntegerField()),
                ('offsets', models.CharField(max_length=255, null=True)),
                ('data', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SampledDataIntervalUnitCodes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('definition', models.TextField(null=True)),
                ('source', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='observationpartof',
            name='observation',
        ),
        migrations.RemoveField(
            model_name='observationperformer',
            name='observation',
        ),
        migrations.RemoveField(
            model_name='observationperformer',
            name='practitioner',
        ),
        migrations.RemoveField(
            model_name='observationvalue',
            name='attachment',
        ),
        migrations.RemoveField(
            model_name='observationvalue',
            name='observation',
        ),
        migrations.RenameField(
            model_name='observation',
            old_name='effective_datetime',
            new_name='effective_date_time',
        ),
        migrations.RenameField(
            model_name='observation',
            old_name='effective_end_datetime',
            new_name='value_date_time',
        ),
        migrations.RenameField(
            model_name='observation',
            old_name='effective_timing',
            new_name='value_string',
        ),
        migrations.RenameField(
            model_name='observation',
            old_name='effective_instant',
            new_name='value_time',
        ),
        migrations.RemoveField(
            model_name='observation',
            name='effective_start_datetime',
        ),
        migrations.RemoveField(
            model_name='observation',
            name='instantiates_canonical',
        ),
        migrations.RemoveField(
            model_name='observation',
            name='patient',
        ),
        migrations.RemoveField(
            model_name='observationcomponent',
            name='observation',
        ),
        migrations.RemoveField(
            model_name='observationcomponent',
            name='value',
        ),
        migrations.RemoveField(
            model_name='observationreferencerange',
            name='observation',
        ),
        migrations.AddField(
            model_name='observation',
            name='component',
            field=models.ManyToManyField(blank=True, related_name='observation_component', to='observations.observationcomponent'),
        ),
        migrations.AddField(
            model_name='observation',
            name='effective_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_effective_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='observation',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='observation_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='observation',
            name='reference_range',
            field=models.ManyToManyField(blank=True, related_name='observation_reference_range', to='observations.observationreferencerange'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_attachment',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_attachment', to='base.attachment'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_boolean',
            field=models.BooleanField(null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_codeable_concept',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_codeable_concept', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_integer',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_quantity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='observation_value', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_range',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_range', to='base.range'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_ratio',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_ratio', to='base.ratio'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_attachment',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_attachment', to='base.attachment'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_boolean',
            field=models.BooleanField(null=True),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_codeable_concept',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_codeable_concept', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_date_time',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_integer',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_quantity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='observation_component_value', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_range',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_range', to='base.range'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_ratio',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_ratio', to='base.ratio'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_string',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_time',
            field=models.TimeField(null=True),
        ),
        migrations.AlterField(
            model_name='observation',
            name='body_site',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_body_site', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='category',
            field=models.ManyToManyField(blank=True, related_name='observation_category', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='data_absent_reason',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_data_absent_reason', to='base.codeableconcept'),
        ),
        migrations.RemoveField(
            model_name='observation',
            name='derived_from',
        ),
        migrations.AlterField(
            model_name='observation',
            name='encounter',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='encounters.encounterreference'),
        ),
        migrations.RemoveField(
            model_name='observation',
            name='focus',
        ),
        migrations.RemoveField(
            model_name='observation',
            name='interpretation',
        ),
        migrations.AlterField(
            model_name='observation',
            name='method',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_method', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='note',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_note', to='base.annotation'),
        ),
        migrations.AlterField(
            model_name='observationcomponent',
            name='code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='observation_component_code', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observationcomponent',
            name='data_absent_reason',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_data_absent_reason', to='base.codeableconcept'),
        ),
        migrations.RemoveField(
            model_name='observationcomponent',
            name='interpretation',
        ),
        migrations.RemoveField(
            model_name='observationcomponent',
            name='reference_range',
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='age',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_range_age', to='base.range'),
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='applies_to',
            field=models.ManyToManyField(blank=True, related_name='reference_range_applies_to', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='high',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_range_high', to='base.quantity'),
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='low',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_range_low', to='base.quantity'),
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='normal_value',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_range_normal_value', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observationreferencerange',
            name='type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_range_type', to='base.codeableconcept'),
        ),
        migrations.RenameModel(
            old_name='TriggeredBy',
            new_name='ObservationTriggeredBy',
        ),
        migrations.DeleteModel(
            name='ObservationBasedOn',
        ),
        migrations.DeleteModel(
            name='ObservationPartOf',
        ),
        migrations.DeleteModel(
            name='ObservationPerformer',
        ),
        migrations.DeleteModel(
            name='ObservationValue',
        ),
        migrations.AddField(
            model_name='sampleddata',
            name='interval_unit',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sampled_data_interval_unit', to='observations.sampleddataintervalunitcodes'),
        ),
        migrations.AddField(
            model_name='sampleddata',
            name='origin',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sampled_data_origin', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='observationreference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_reference_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='observationhasmemberreference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_has_member_reference_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='observationderivedfromreference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_derived_from_reference_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='observation',
            name='based_on',
            field=models.ManyToManyField(blank=True, related_name='observation_based_on', to='observations.observationbasedonreference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='part_of',
            field=models.ManyToManyField(blank=True, to='observations.observationpartofreference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='performer',
            field=models.ManyToManyField(blank=True, related_name='observation_performer', to='observations.observationperformerreference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='observation_subject', to='observations.observationsubjectreference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='observations.observationmolecularsequencereference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='value_sampled_data',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_value_sampled_data', to='observations.sampleddata'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='observations.observationmolecularsequencereference'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='value_sampled_data',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_value_sampled_data', to='observations.sampleddata'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='body_structure',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_body_structure', to='observations.observationbodystructurereference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='derived_from',
            field=models.ManyToManyField(blank=True, related_name='observation_derived_from', to='observations.observationderivedfromreference'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='device',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_device', to='observations.observationdevicereference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='focus',
            field=models.ManyToManyField(related_name='observation_focus', to='base.reference'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='has_member',
            field=models.ManyToManyField(blank=True, related_name='observation_has_member', to='observations.observationhasmemberreference'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='instantiates_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_instantiates_reference', to='observations.observationdefinitionreference'),
        ),
        migrations.AddField(
            model_name='observation',
            name='interpretation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_interpretation', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='observation',
            name='specimen',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_specimen', to='observations.observationspecimenreference'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='interpretation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='observation_component_interpretation', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='observationcomponent',
            name='reference_range',
            field=models.ManyToManyField(blank=True, to='observations.observationreferencerange'),
        ),
        migrations.AlterField(
            model_name='observationtriggeredby',
            name='observation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='triggered_by_observation', to='observations.observationreference'),
        ),
    ]
