# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BodySite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Interpretation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Observation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('registered', 'Registered'), ('preliminary', 'Preliminary'), ('final', 'Final'), ('amended', 'Amended'), ('corrected', 'Corrected'), ('cancelled', 'Cancelled'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('focus', models.CharField(help_text='Focus of an observation when it is not the subject of record', max_length=255, null=True)),
                ('effective_datetime', models.DateTimeField(null=True)),
                ('effective_start_datetime', models.DateTimeField(null=True)),
                ('effective_end_datetime', models.DateTimeField(null=True)),
                ('effective_timing', models.CharField(max_length=255, null=True)),
                ('effective_instant', models.TimeField(null=True)),
                ('issued', models.DateTimeField(null=True)),
                ('data_absent_reason', models.CharField(choices=[('unknown', 'Unknown'), ('asked-unknown', 'Asked but unknown'), ('temporarily_unknown', 'Temporarily unknown'), ('not_asked', 'Not asked'), ('asked_declined', 'Asked but declined'), ('masked', 'Masked'), ('not_applicable', 'Not applicable'), ('unsupported', 'Unsupported'), ('as_text', 'As text'), ('error', 'Error'), ('not_a_number', 'Not a number'), ('negative_infinity', 'Negative infinity'), ('positive_infinity', 'Positive infinity'), ('not_performed', 'Not performed'), ('not_permitted', 'Not permitted')], max_length=255, null=True)),
                ('note', models.TextField(null=True)),
                ('instantiates_canonical', models.CharField(max_length=255, null=True)),
                ('instantiates_reference', models.CharField(max_length=255, null=True)),
                ('specimen', models.CharField(max_length=255, null=True)),
                ('device', models.CharField(max_length=255, null=True)),
                ('derived_from', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationBasedOn',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('based_on', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationCodes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationComponent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('data_absent_reason', models.CharField(choices=[('unknown', 'Unknown'), ('asked-unknown', 'Asked but unknown'), ('temporarily_unknown', 'Temporarily unknown'), ('not_asked', 'Not asked'), ('asked_declined', 'Asked but declined'), ('masked', 'Masked'), ('not_applicable', 'Not applicable'), ('unsupported', 'Unsupported'), ('as_text', 'As text'), ('error', 'Error'), ('not_a_number', 'Not a number'), ('negative_infinity', 'Negative infinity'), ('positive_infinity', 'Positive infinity'), ('not_performed', 'Not performed'), ('not_permitted', 'Not permitted')], max_length=255, null=True)),
                ('reference_range', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationPartOf',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('part_of', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReferenceRangeAppliesCodes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TriggeredBy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('reflex', 'Reflex'), ('repeat', 'Repeat'), ('re_run', 'Re-run')], max_length=255, null=True)),
                ('reason', models.TextField(null=True)),
                ('observation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='triggered_by_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('string', models.CharField(max_length=255, null=True)),
                ('boolean', models.BooleanField(null=True)),
                ('integer', models.IntegerField(null=True)),
                ('lower_range', models.IntegerField(null=True)),
                ('upper_range', models.IntegerField(null=True)),
                ('ratio_numerator', models.IntegerField(null=True)),
                ('ratio_denominator', models.IntegerField(null=True)),
                ('datetime', models.DateTimeField(null=True)),
                ('period_start_datetime', models.DateTimeField(null=True)),
                ('period_end_datetime', models.DateTimeField(null=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('quantity', models.JSONField(null=True)),
                ('attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='observation_attachment', to='base.attachment')),
                ('observation', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='observation_value', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationReferenceRange',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('low', models.IntegerField(null=True)),
                ('high', models.IntegerField(null=True)),
                ('normal_value', models.CharField(choices=[('negative', 'Negative'), ('absent', 'Absent')], max_length=255, null=True)),
                ('type', models.CharField(choices=[('type', 'Type'), ('normal_range', 'Normal Range'), ('recommended_range', 'Recommended Range'), ('treatment_range', 'Treatment Range'), ('therapeutic_desired_level', 'Therapeutic Desired Level'), ('pre_therapeutic_desired_level', 'Pre-Therapeutic Desired Level'), ('post_therapeutic_desired_level', 'Post-Therapeutic Desired Level'), ('endocrine', 'Endocrine'), ('pre_puberty', 'Pre-Puberty'), ('follicular_stage', 'Follicular Stage'), ('mid_cycle', 'Mid-Cycle'), ('luteal', 'Luteal'), ('post_menopause', 'Post-Menopause')], max_length=255, null=True)),
                ('age', models.CharField(max_length=255, null=True)),
                ('text', models.TextField(null=True)),
                ('applies_to', models.ManyToManyField(blank=True, related_name='reference_range_applies_to', to='observations.referencerangeappliescodes')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='observation_reference_range', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationPerformer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='observation_performer', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
