# Generated by Django 4.2.14 on 2025-02-03 17:42

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('careplans', '0002_remove_careplan_goal_careplan_note'),
        ('organizations', '0003_organization_endpoint'),
        ('servicerequests', '0004_alter_servicerequest_intent'),
        ('encounters', '0008_alter_encounterlocation_location'),
        ('patients', '0007_patientorganizationreference'),
        ('devicedefinitions', '0002_devicedefinitiondeviceversion_and_more'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('base', '0010_expression_relativetime'),
        ('practitioners', '0010_practitionerrole_endpoint'),
    ]

    operations = [
        migrations.CreateModel(
            name='NutritionOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instantiates_uri', models.URLField(null=True)),
                ('instantiated', models.URLField(null=True)),
                ('status', models.CharField(blank=True, choices=[('draft', 'Draft'), ('active', 'Active'), ('on-hold', 'On Hold'), ('revoked', 'Revoked'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255)),
                ('intent', models.CharField(choices=[('proposal', 'Proposal'), ('plan', 'Plan'), ('order', 'Order'), ('directive-order', 'Directive Order'), ('original-order', 'Original Order'), ('reflex-order', 'Reflex Order'), ('filler-order', 'Filler Order'), ('instance-order', 'Instance Order'), ('option', 'Option')], max_length=255, null=True)),
                ('priority', models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('stat', 'Stat'), ('asap', 'ASAP')], max_length=255, null=True)),
                ('date_time', models.DateTimeField(null=True)),
                ('outside_food_allowed', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderSchedule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('as_needed', models.BooleanField(default=False)),
                ('as_needed_for', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_schedule_as_needed_for', to='base.codeableconcept')),
                ('timing', models.ManyToManyField(blank=True, related_name='nutrition_order_oral_diet_schedule_timing', to='base.timing')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderSupplement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('productName', models.CharField(blank=True, max_length=255)),
                ('instruction', models.TextField(blank=True)),
                ('caloric_density', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_supplement_caloric_density', to='base.quantity')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_supplement_quantity', to='base.quantity')),
                ('schedule', models.ManyToManyField(blank=True, related_name='nutrition_order_supplement_schedule', to='nutritionorders.nutritionorderschedule')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_reference_identifier', to='base.identifier')),
                ('nutrition_order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_reference_nutrition_order', to='nutritionorders.nutritionorder')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_care_team', to='careteams.careteam')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_performer_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderOralDietTexture',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('modifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_texture_modifier', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_texture_food_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderOralDietNutrient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_nutrient_amount', to='base.quantity')),
                ('modifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_nutrient_modifier', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderOralDiet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instruction', models.TextField(blank=True)),
                ('caloric_density', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet_caloric_density', to='base.quantity')),
                ('nutrient', models.ManyToManyField(blank=True, related_name='nutrition_order_oral_diet_nutrient', to='nutritionorders.nutritionorderoraldietnutrient')),
                ('schedule', models.ManyToManyField(blank=True, related_name='nutrition_order_oral_diet_schedule', to='nutritionorders.nutritionorderschedule')),
                ('texture', models.ManyToManyField(blank=True, related_name='nutrition_order_oral_diet_texture', to='nutritionorders.nutritionorderoraldiettexture')),
                ('type', models.ManyToManyField(related_name='nutrition_order_oral_diet_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderEnteralFormulaAdministration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_administration_quantity', to='base.quantity')),
                ('rate_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_administration_rate_quantity', to='base.quantity')),
                ('rate_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_administration_rate_ratio', to='base.ratio')),
                ('schedule', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_administration_schedule', to='nutritionorders.nutritionorderschedule')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderEnteralFormula',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('product_name', models.CharField(max_length=255, null=True)),
                ('administration_instruction', models.TextField(blank=True)),
                ('administration', models.ManyToManyField(blank=True, related_name='nutrition_order_enternal_formula_administration', to='nutritionorders.nutritionorderenteralformulaadministration')),
                ('caloric_density', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_caloric_density', to='base.quantity')),
                ('delivery_Device', models.ManyToManyField(blank=True, related_name='nutrition_order_enternal_formula_delivery_device', to='devicedefinitions.devicedefinitioncodeablereference')),
                ('max_volume_to_administer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enternal_formula_max_volume_to_administer', to='base.quantity')),
                ('route_of_administration', models.ManyToManyField(blank=True, related_name='nutrition_order_enternal_formula_route_of_administration', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_codeable_reference_reference', to='nutritionorders.nutritionorderreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderBasedOnReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_based_on_reference_care_plan', to='careplans.careplan')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_based_on_reference_identifier', to='base.identifier')),
                ('nutrition_order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_based_on_reference_nutrition_order', to='nutritionorders.nutritionorder')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_based_on_reference_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NutritionOrderAdditive',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('product_name', models.CharField(blank=True, max_length=255)),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_additive_quantity', to='base.quantity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='additive',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_additive', to='nutritionorders.nutritionorderadditive'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='allergy_intolerance',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_allergy_intolerance', to='base.reference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='based_on',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_based_on', to='nutritionorders.nutritionorderbasedonreference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='encounter',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='nutrition_order_encounter', to='encounters.encounterreference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='enteral_formula',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_enteral_formula', to='nutritionorders.nutritionorderenteralformula'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='exclude_food_modifier',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_exclude_food_modifier', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='food_preference_modifier',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_food_preference_modifier', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='group_identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='nutrition_order_group_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='oral_diet',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nutrition_order_oral_diet', to='nutritionorders.nutritionorderoraldiet'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='orderer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='nutrition_order_orderer', to='practitioners.practitionerpractitionerrolereference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='performer',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_performer', to='nutritionorders.nutritionorderperformerreference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='nutrition_order_subject', to='patients.patientgroupreference'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='supplement',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_supplement', to='nutritionorders.nutritionordersupplement'),
        ),
        migrations.AddField(
            model_name='nutritionorder',
            name='supporting_information',
            field=models.ManyToManyField(blank=True, related_name='nutrition_order_supporting_information', to='base.reference'),
        ),
    ]
