# Generated by Django 4.2.14 on 2025-02-17 16:19

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("base", "0012_alter_repeat_duration_unit_alter_repeat_period_unit"),
    ]

    operations = [
        migrations.CreateModel(
            name="MolecularDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.CharField(
                        choices=[("aa", "aa"), ("dna", "dna"), ("ma", "ma")],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="molecular_definition_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionCytobandInterval",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "chromosome",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="cytoband_interval_chromosome",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionCytobandIntervalStartEndCytoband",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("arm_code", models.CharField(max_length=255, null=True)),
                ("arm_string", models.CharField(max_length=255, null=True)),
                ("region_code", models.CharField(max_length=255, null=True)),
                ("region_string", models.CharField(max_length=255, null=True)),
                ("band_code", models.CharField(max_length=255, null=True)),
                ("band_string", models.CharField(max_length=255, null=True)),
                ("sub_band_code", models.CharField(max_length=255, null=True)),
                ("sub_band_string", models.CharField(max_length=255, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionCytobandLocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "cytoband_interval",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="cytoband_location_cytoband_interval",
                        to="moleculardefinitions.moleculardefinitioncytobandinterval",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionFeatureLocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "gene_id",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="feature_location_gene_id",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="molecular_definition_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "molecular_definition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="molecular_definition_reference_molecular_definition",
                        to="moleculardefinitions.moleculardefinition",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularSequenceGenomeAssembly",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("description_markdown", models.TextField(null=True)),
                ("description_string", models.CharField(max_length=255, null=True)),
                (
                    "accession",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genome_assembly_accession",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "build",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genome_assembly_build",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "organism",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genome_assembly_organism",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionSequenceLocationCoordinateInternal",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "end_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="coordinate_internal_end_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "end_range",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="coordinate_internal_end_range",
                        to="base.range",
                    ),
                ),
                (
                    "numbering_system",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="coordinate_internal_numbering_system",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "start_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="coordinate_internal_start_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "start_range",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="coordinate_internal_start_range",
                        to="base.range",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionSequenceLocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "coordinated_internal",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="sequence_location_coordinated_internal",
                        to="moleculardefinitions.moleculardefinitionsequencelocationcoordinateinternal",
                    ),
                ),
                (
                    "sequence_context",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="sequence_location_sequence_context",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
                (
                    "strand",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="sequence_location_strand",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationRepeated",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "sequence_motif",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_extract_sequence_motif",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationRelativeEdit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("edit_order", models.IntegerField(null=True)),
                ("start", models.IntegerField(null=True)),
                ("end", models.IntegerField(null=True)),
                (
                    "coordinate_system",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_coordinate_system",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "replaced_molecule",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_edit_replaced_molecule",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "replacement_molecule",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_edit_replacement_molecule",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationRelative",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "edit",
                    models.ManyToManyField(
                        blank=True,
                        related_name="representation_edit_relative",
                        to="moleculardefinitions.moleculardefinitionrepresentationrelativeedit",
                    ),
                ),
                (
                    "starting_molecule",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_starting_molecule",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationLiteral",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value", models.CharField(max_length=255, null=True)),
                (
                    "encoding",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_literal_encoding",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationExtracted",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("start", models.IntegerField(null=True)),
                ("end", models.IntegerField(null=True)),
                ("reverse_complement", models.BooleanField(default=False)),
                (
                    "coordinate_system",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_extract_coordinate_system",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "string_molecule",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_extract_string_molecule",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationConcatenatedSequenceElement",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("ordinal_index", models.IntegerField(null=True)),
                (
                    "sequence",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_concatenated_sequence_element_sequence",
                        to="moleculardefinitions.moleculardefinitionreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentationConcatenated",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "sequence_element",
                    models.ManyToManyField(
                        blank=True,
                        related_name="representation_concatenated",
                        to="moleculardefinitions.moleculardefinitionrepresentationconcatenatedsequenceelement",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionRepresentation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "code",
                    models.ManyToManyField(
                        blank=True,
                        related_name="representation_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "concatenated",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_concatenated",
                        to="moleculardefinitions.moleculardefinitionrepresentationconcatenated",
                    ),
                ),
                (
                    "extracted",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_extracted",
                        to="moleculardefinitions.moleculardefinitionrepresentationextracted",
                    ),
                ),
                (
                    "focus",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_focus",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "literal",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_literal",
                        to="moleculardefinitions.moleculardefinitionrepresentationliteral",
                    ),
                ),
                (
                    "relative",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_relative",
                        to="moleculardefinitions.moleculardefinitionrepresentationrelative",
                    ),
                ),
                (
                    "repeated",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_repeat",
                        to="moleculardefinitions.moleculardefinitionrepresentationrepeated",
                    ),
                ),
                (
                    "resolvable",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="representation_resolvable",
                        to="base.attachment",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MolecularDefinitionLocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "cytoband_location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="molecular_definition_cytoband_location",
                        to="moleculardefinitions.moleculardefinitioncytobandlocation",
                    ),
                ),
                (
                    "featured_location",
                    models.ManyToManyField(
                        blank=True,
                        related_name="molecular_definition_featured_location",
                        to="moleculardefinitions.moleculardefinitionfeaturelocation",
                    ),
                ),
                (
                    "sequence_location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="molecular_definition_sequence_location",
                        to="moleculardefinitions.moleculardefinitionsequencelocation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="moleculardefinitioncytobandlocation",
            name="genome_assembly",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="cytoband_location_genome_assembly",
                to="moleculardefinitions.molecularsequencegenomeassembly",
            ),
        ),
        migrations.AddField(
            model_name="moleculardefinitioncytobandinterval",
            name="end_cytoband",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="cytoband_interval_end_cytoband",
                to="moleculardefinitions.moleculardefinitioncytobandintervalstartendcytoband",
            ),
        ),
        migrations.AddField(
            model_name="moleculardefinitioncytobandinterval",
            name="start_cytoband",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="cytoband_interval_start_cytoband",
                to="moleculardefinitions.moleculardefinitioncytobandintervalstartendcytoband",
            ),
        ),
        migrations.AddField(
            model_name="moleculardefinition",
            name="location",
            field=models.ManyToManyField(
                blank=True,
                related_name="molecular_definition_location",
                to="moleculardefinitions.moleculardefinitionlocation",
            ),
        ),
        migrations.AddField(
            model_name="moleculardefinition",
            name="member_state",
            field=models.ManyToManyField(
                blank=True,
                related_name="molecular_definition_member_state",
                to="moleculardefinitions.moleculardefinitionreference",
            ),
        ),
        migrations.AddField(
            model_name="moleculardefinition",
            name="representation",
            field=models.ManyToManyField(
                blank=True,
                related_name="molecular_definition_representation",
                to="moleculardefinitions.moleculardefinitionrepresentation",
            ),
        ),
    ]
