# Generated by Django 4.2.14 on 2025-02-25 12:16

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.fields.related


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("devices", "0007_alter_device_status_and_more"),
        ("base", "0013_money"),
        ("organizations", "0003_organization_endpoint"),
        ("conditions", "0006_merge_20250217_1423"),
        ("diagnosticreports", "0005_diagnosticreportdocumentreferencereference"),
        ("patients", "0007_patientorganizationreference"),
        ("procedures", "0008_merge_20250218_1723"),
        ("observations", "0008_alter_observationcodeablereference_concept_and_more"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
    ]

    operations = [
        migrations.CreateModel(
            name="MedicationStatement",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("recorded", "Recorded"),
                            ("entered-in-error", "Entered in error"),
                            ("draft", "Draft"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("effective_date_time", models.DateTimeField(null=True)),
                ("date_asserted", models.DateTimeField(null=True)),
                ("related_clinical_information", models.TextField(null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationStatementReasonReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_reason_reference_condition",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_reason_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_reason_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_reason_reference_observation",
                        to="observations.observation",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_reason_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationStatementPartOfReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_part_of_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_statement",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_part_of_reference_medication_statement",
                        to="medicationstatements.medicationstatement",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_part_of_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationStatementInformationSourceReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_information_source_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationStatementAdherence",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_adherence_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "reason",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_statement_adherence_reason",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="adherence",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_adherence",
                to="medicationstatements.medicationstatementadherence",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="category",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_category",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="derived_from",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_derived_from",
                to="base.reference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="effective_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="medication_statement_effective_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="effective_timing",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.fields.related.ForeignKey,
                related_name="medication_statement_effective_timing",
                to="base.timing",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="medication_statement_encounter",
                to="encounters.encounterreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="information_source",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_information_source",
                to="medicationstatements.medicationstatementinformationsourcereference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="medication",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="medication_statement_medication",
                to="medications.medicationcodeablereference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="note",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_note",
                to="base.annotation",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="part_of",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_part_of",
                to="medicationstatements.medicationstatementpartofreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_statement_reason",
                to="medicationstatements.medicationstatementreasonreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationstatement",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="medication_statement_subject",
                to="patients.patientgroupreference",
            ),
        ),
    ]
