# Generated by Django 4.2.14 on 2025-01-08 12:22

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0003_communication'),
        ('medications', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='MedicationBatch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('lot_number', models.CharField(max_length=255, null=True)),
                ('expiration_date', models.DateTimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='medication',
            name='expiration_date',
        ),
        migrations.RemoveField(
            model_name='medication',
            name='lot_number',
        ),
        migrations.RemoveField(
            model_name='medicationingredient',
            name='medication',
        ),
        migrations.RemoveField(
            model_name='medicationingredient',
            name='strength_quantity',
        ),
        migrations.RemoveField(
            model_name='medicationingredient',
            name='strength_ratio',
        ),
        migrations.AddField(
            model_name='medication',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='medication',
            name='ingredient',
            field=models.ManyToManyField(blank=True, related_name='medication_ingredient', to='medications.medicationingredient'),
        ),
        migrations.AddField(
            model_name='medicationingredient',
            name='is_active',
            field=models.BooleanField(default=True),
        ),
        migrations.AlterField(
            model_name='medication',
            name='code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_code', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='dose_form',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_dose_form', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='marketing_authorization_holder',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_organization', to='base.organizationreference'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='status',
            field=models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive'), ('entered_in_error', 'Entered in error')], max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='medication',
            name='total_volume',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_total_volume', to='base.quantity'),
        ),
        migrations.CreateModel(
            name='Ratio',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('denominator', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='ratio_denominator', to='base.quantity')),
                ('numerator', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='ratio_numerator', to='base.quantity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationSubstanceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_substance_reference_identifier', to='base.identifier')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_substance_reference', to='medications.medication')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationSubstanceCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_substance_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_substance_codeable_reference_reference', to='medications.medicationsubstancereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationIngredientStrength',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('strength_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='mediation_ingredient_strength_codeable_concept', to='base.codeableconcept')),
                ('strength_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='mediation_ingredient_strength_quantity', to='base.quantity')),
                ('strength_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='mediation_ingredient_strength_ratio', to='medications.ratio')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='medication',
            name='batch',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='medication_batch', to='medications.medicationbatch'),
        ),
        migrations.AlterField(
            model_name='medicationingredient',
            name='item',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='mediation_ingredient_item', to='medications.medicationsubstancecodeablereference'),
        ),
        migrations.AlterField(
            model_name='medicationingredient',
            name='strength',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='mediation_ingredient_strength', to='medications.medicationingredientstrength'),
        ),
    ]
