# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('organizations', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdditionalIllustration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DosageMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DosageRoute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DosageSite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InformationSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('group_identifier', models.CharField(max_length=255, null=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('on_hold', 'On hold'), ('ended', 'Ended'), ('stopped', 'Stopped'), ('completed', 'Completed'), ('cancelled', 'Cancelled'), ('entered_in_error', 'Entered in error'), ('draft', 'Draft'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('status_reason', models.CharField(choices=[('try_another_treatment_first', 'Try another treatment first'), ('prescription_requires_clarification', 'Prescription requires clarification'), ('drug_level_too_high', 'Drug level too high'), ('admission_to_hospital', 'Admission to hospital'), ('lab_interference_issues', 'Lab interference issues'), ('patient_not_available', 'Patient not available'), ('patient_is_pregnant', 'Patient is pregnant'), ('patient_is_breastfeeding', 'Patient is breastfeeding'), ('allergy', 'Allergy'), ('drug_interacts_with_another_drug', 'Drug interacts with another drug'), ('duplicate_therapy', 'Duplicate therapy'), ('suspected_intolerance', 'suspected intolerance'), ('patient_scheduled_for_surgery', 'Patient scheduled for surgery'), ('waiting_for_old_drug_to_wash_out', 'Waiting for old drug to wash out')], max_length=255, null=True)),
                ('status_changed', models.DateTimeField(null=True)),
                ('intent', models.CharField(choices=[('plan', 'Plan'), ('order', 'Order'), ('original_order', 'Original order'), ('filler_order', 'Filler order'), ('instance_order', 'Instance order'), ('option', 'Option')], max_length=255, null=True)),
                ('priority', models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('asap', 'ASAP'), ('stat', 'STAT')], max_length=255, null=True)),
                ('do_not_perform', models.BooleanField(default=False)),
                ('authored_on', models.DateTimeField(null=True)),
                ('reported', models.BooleanField(default=True)),
                ('performer_type', models.CharField(choices=[('registered_nurse', 'Registered nurse'), ('oncology_nurse', 'Oncology nurse'), ('pain_control_nurse', 'Pain control nurse'), ('physician', 'Physician'), ('pharmacist', 'Pharmacist')], max_length=255, null=True)),
                ('device', models.CharField(max_length=255, null=True)),
                ('course_of_therapy_type', models.CharField(choices=[('continuous_long_term_therapy', 'Continuous long term therapy'), ('short_course_therapy', 'Short course therapy'), ('seasonal', 'Seasonal')], max_length=255, null=True)),
                ('insurance', models.CharField(max_length=255, null=True)),
                ('note', models.TextField(null=True)),
                ('rendered_dosage_instruction', models.CharField(max_length=255, null=True)),
                ('effective_dose_period_start', models.DateTimeField(null=True)),
                ('effective_dose_period_end', models.DateTimeField(null=True)),
                ('quantity', models.IntegerField(null=True)),
                ('duration', models.IntegerField(null=True)),
                ('dispense_interval', models.IntegerField(null=True)),
                ('validity_period', models.IntegerField(null=True)),
                ('number_of_repeats_allowed', models.IntegerField(null=True)),
                ('expected_supply_duration', models.IntegerField(null=True)),
                ('dispense_instruction', models.TextField(null=True)),
                ('dose_administration_aid', models.CharField(choices=[('blister_pack', 'Blister pack'), ('dosette', 'Dosette'), ('sachets', 'Sachets')], max_length=255, null=True)),
                ('event_history', models.CharField(max_length=255, null=True)),
                ('allowed', models.BooleanField(default=True)),
                ('reason', models.CharField(choices=[('continuing_therapy', 'Continuing therapy'), ('formulary_policy', 'Formulary policy'), ('out of stock', 'Out of stock'), ('regulatory_requirements', 'Regulatory requirements')], max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestBasedOn',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestDosage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.CharField(max_length=255, null=True)),
                ('text', models.CharField(max_length=255, null=True)),
                ('patient_illustration', models.CharField(max_length=255, null=True)),
                ('timing', models.IntegerField(null=True)),
                ('as_needed', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestDoseAndRate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('dose_and_rate_type', models.CharField(choices=[('calculated', 'Calculated'), ('ordered', 'Ordered')], max_length=255, null=True)),
                ('dose_range', models.CharField(max_length=255, null=True)),
                ('dose_quantity', models.CharField(max_length=255, null=True)),
                ('rate_ratio', models.CharField(max_length=255, null=True)),
                ('rate_range', models.CharField(max_length=255, null=True)),
                ('rate_quantity', models.CharField(max_length=255, null=True)),
                ('max_dose_numerator', models.IntegerField(null=True)),
                ('max_dose_denominator', models.IntegerField(null=True)),
                ('max_dose_per_administration', models.IntegerField(null=True)),
                ('max_dose_per_lifetime', models.IntegerField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestMedicationCode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestReason',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestReferenceType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MedicationRequestSupportingInformation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReferenceAsNeededFor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Requester',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('medication_request', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='requester_medication_request', to='medicationrequests.medicationrequest')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='requester_organization', to='organizations.organization')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
