# Generated by Django 4.2.14 on 2025-02-25 09:24

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("substances", "0002_substancecodeablereference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        (
            "documentreferences",
            "0003_rename_base_on_documentreference_based_on_and_more",
        ),
        ("base", "0013_money"),
    ]

    operations = [
        migrations.CreateModel(
            name="MedicationKnowledge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("active", "Active"),
                            ("retired", "Retired"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("name", models.CharField(max_length=255, null=True)),
                ("preparation_instruction", models.TextField(null=True)),
                (
                    "associate_medication",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_associate_medication",
                        to="medications.medicationreference",
                    ),
                ),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_author",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_code",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeCost",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("source", models.CharField(max_length=255, null=True)),
                (
                    "cost_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_cost_cost_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "cost_money",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_cost_cost_money",
                        to="base.money",
                    ),
                ),
                (
                    "effective_date",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="base.period",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_cost_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeDosingGuidelineDosage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "administration_treatment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_dosing_guideline_dosage_administration_treatment",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_dosing_guideline_dosage_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeIndicationGuidelineDosingGuideline",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "administration_treatment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_dosing_guideline_administration_treatment",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "dose",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_dosing_guideline_dose",
                        to="medicationknowledges.medicationknowledgedosingguidelinedosage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_knowledge",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_reference_medication_knowledge",
                        to="medicationknowledges.medicationknowledge",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeStorageGuidelineEnvironmentalSetting",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="storage_guideline_environmental_setting_value_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="storage_guideline_environmental_setting_value_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "value_range",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="storage_guideline_environmental_setting_value_range",
                        to="base.range",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeStorageGuideline",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.URLField(null=True)),
                (
                    "environmental_setting",
                    models.ManyToManyField(
                        blank=True,
                        related_name="storage_guideline_environmental_setting",
                        to="medicationknowledges.medicationknowledgestorageguidelineenvironmentalsetting",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="storage_guideline_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "stability_duration",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="storage_guideline_stability_duration",
                        to="base.duration",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeRelatedMedicationKnowledge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_related_medication_knowledge_reference",
                        to="medicationknowledges.medicationknowledgereference",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_related_medication_knowledge_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeRegulatorySubstitution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("allowed", models.BooleanField(null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="regulatory_substitution_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeRegulatoryMaxDispense",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="regulatory_max_dispense_period",
                        to="base.period",
                    ),
                ),
                (
                    "quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="regulatory_max_dispense_quantity",
                        to="base.simplequantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeRegulatory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "max_dispense",
                    models.ManyToManyField(
                        blank=True,
                        related_name="regulatory_max_dispense",
                        to="medicationknowledges.medicationknowledgeregulatorymaxdispense",
                    ),
                ),
                (
                    "regulatory_authority",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="regulatory_authority",
                        to="base.organizationreference",
                    ),
                ),
                (
                    "schedule",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_schedule",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "substitution",
                    models.ManyToManyField(
                        blank=True,
                        related_name="regulatory_substitution",
                        to="medicationknowledges.medicationknowledgeregulatorysubstitution",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgePatientCharacteristics",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="med_knowledge_dosing_guideline_treatment_intent_dosage_patient_characteristics_type",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="med_knowledge_dosing_guideline_treatment_intent_dosage_patient_characteristics_value_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="med_knowledge_dosing_guideline_treatment_intent_dosage_patient_characteristics_value_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "value_range",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="med_knowledge_dosing_guideline_treatment_intent_dosage_patient_characteristics_value_range",
                        to="base.range",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgePackaging",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "cost",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_packaging_cost",
                        to="medicationknowledges.medicationknowledgecost",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeMonograph",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "source",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_monograph_source",
                        to="documentreferences.documentreferencereference",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_monograph_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeMonitoringProgram",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=255, null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_monitoring_program_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeMedicineClassification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("source_string", models.CharField(max_length=255, null=True)),
                ("source_uri", models.URLField(null=True)),
                (
                    "classification",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_medicine_classification_classification",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_medicine_classification_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeIndicationGuidline",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "dosing_guideline",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_indication_guidline_dosing_guideline",
                        to="medicationknowledges.medicationknowledgeindicationguidelinedosingguideline",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="medicationknowledgeindicationguidelinedosingguideline",
            name="patient_characteristics",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_dosing_guideline_patient_characteristics",
                to="medicationknowledges.medicationknowledgepatientcharacteristics",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledgeindicationguidelinedosingguideline",
            name="treatment_intent",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="medication_knowledge_dosing_guideline_treatement_intent",
                to="base.codeableconcept",
            ),
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeDefinitionalIngredient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_ingredient_item",
                        to="substances.substancecodeablereference",
                    ),
                ),
                (
                    "strength_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_ingredient_strength_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "strength_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_ingredient_strength_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "strength_ratio",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_ingredient_strength_ratio",
                        to="base.ratio",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_ingredient_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeDefinitionalDrugCharacteristic",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value_string", models.CharField(max_length=255, null=True)),
                ("value_base_64_binary", models.BinaryField(null=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_drug_characteristic_type",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_attachment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_drug_characteristic_value_attachment",
                        to="base.attachment",
                    ),
                ),
                (
                    "value_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_drug_characteristic_value_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "value_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_drug_characteristic_value_quantity",
                        to="base.quantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationKnowledgeDefinitional",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "dose_form",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_knowledge_definitional_dose_form",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "drug_characteristic",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_definitional_drug_chracteristic",
                        to="medicationknowledges.medicationknowledgedefinitionaldrugcharacteristic",
                    ),
                ),
                (
                    "ingredient",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_definitional_ingredient",
                        to="medicationknowledges.medicationknowledgedefinitionalingredient",
                    ),
                ),
                (
                    "intended_route",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_knowledge_definitional_intended_route",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="cost",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_cost",
                to="medicationknowledges.medicationknowledgecost",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="definitional",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_definitional",
                to="medicationknowledges.medicationknowledgedefinitional",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="indication_guideline",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_indication_guideline",
                to="medicationknowledges.medicationknowledgeindicationguidline",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="jurisdiction",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_jurisdiction",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="medicine_classification",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_medicine_classification",
                to="medicationknowledges.medicationknowledgemedicineclassification",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="monitoring_program",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_monitoring_program",
                to="medicationknowledges.medicationknowledgemonitoringprogram",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="monograph",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_monograph",
                to="medicationknowledges.medicationknowledgemonograph",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="packaging",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_packaging",
                to="medicationknowledges.medicationknowledgepackaging",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="product_type",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_product_type",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="regulatory",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_regulatory",
                to="medicationknowledges.medicationknowledgeregulatory",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="related_medication_knowledge",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_related_medication_knowledge",
                to="medicationknowledges.medicationknowledgerelatedmedicationknowledge",
            ),
        ),
        migrations.AddField(
            model_name="medicationknowledge",
            name="storage_guideline",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_knowledge_storage_guideline",
                to="medicationknowledges.medicationknowledgestorageguideline",
            ),
        ),
    ]
