# Generated by Django 4.2.14 on 2025-01-22 15:47

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("organizations", "0001_initial"),
        ("base", "0005_codeablereference"),
        ("encounters", "0008_alter_encounterlocation_location"),
        ("patients", "0006_patientgroupreference_group_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("provenances", "0001_initial"),
        ("practitioners", "0008_practitionerpractitionerrolereference"),
        ("careplans", "0001_initial"),
        ("locations", "0003_alter_locationorganizationreference_location_and_more"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="MedicatoinDispenseReceiverReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="locations.location",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationDispenseSubstitutionResponsiblePartyReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="organizations.organization",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitionerrole",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationDispenseSubstitution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("was_substituted", models.BooleanField(default=False)),
                (
                    "reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_substitution_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "responsible_party",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_substitution_responsible_party",
                        to="medicationdispenses.medicationdispensesubstitutionresponsiblepartyreference",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_substitution_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationDispensePerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationDispensePerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_performer_actor",
                        to="medicationdispenses.medicationdispenseperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationDispense",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("when_prepared", models.DateTimeField(null=True)),
                ("when_handed_over", models.DateTimeField(null=True)),
                ("rendered_dosage_instructions", models.TextField()),
                (
                    "authorizing_prescription",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_authorizing_prescription",
                        to="medicationrequests.medicationrequestreference",
                    ),
                ),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True, to="careplans.careplanreference"
                    ),
                ),
                (
                    "category",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_category",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "days_supply",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_days_supply",
                        to="base.quantity",
                    ),
                ),
                (
                    "destination",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_destination",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
                (
                    "event_history",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_event_history",
                        to="provenances.provenance",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_location",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="medications.medicationcodeablereference",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "performer",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_performer",
                        to="medicationdispenses.medicationdispenseperformer",
                    ),
                ),
                (
                    "quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "receiver",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_dispense_receiver",
                        to="medicationdispenses.medicatoindispensereceiverreference",
                    ),
                ),
                (
                    "status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="medication_dispense_status",
                        to="base.coding",
                    ),
                ),
                (
                    "subject",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_subject",
                        to="patients.patientgroupreference",
                    ),
                ),
                (
                    "substitution",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_substitution",
                        to="medicationdispenses.medicationdispensesubstitution",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_dispense_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
