# Generated by Django 4.2.14 on 2025-01-23 15:39

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("diagnosticreports", "0004_rename_media_diagnosticreportmedia_and_more"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("encounters", "0008_alter_encounterlocation_location"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("observations", "0002_initial"),
        ("practitioners", "0008_practitionerpractitionerrolereference"),
        ("patients", "0006_patientgroupreference_group_and_more"),
        ("base", "0005_codeablereference"),
        ("conditions", "0002_alter_conditioncodeablereference_concept_and_more"),
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="MedicationAdministration",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("in-progress", "In Progress"),
                            ("not-done", "Not Done"),
                            ("on-hold", "On Hold"),
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in Error"),
                            ("stopped", "Stopped"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=200,
                        null=True,
                    ),
                ),
                ("occurrence_date_time", models.DateTimeField(null=True)),
                ("recorded", models.DateTimeField(null=True)),
                ("is_sub_potent", models.BooleanField(null=True)),
                (
                    "category",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_administration_category",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "device",
                    models.ManyToManyField(
                        blank=True,
                        related_name="medication_administration_device",
                        to="devices.devicecodeablereference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationReasonReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_reference_condition",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_reference_observation",
                        to="observations.observation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationReasonCodeableReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_codeable_reference_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_reason_codeable_reference_reference",
                        to="medicationadministrations.medicationadministrationreasonreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_actor",
                        to="medicationadministrations.medicationadministrationperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_performer_function",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationPartOf",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="medication_administration_part_of_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_administraton",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_part_of_medication_administration",
                        to="medicationadministrations.medicationadministration",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="MedicationAdministrationDosage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("text", models.TextField(null=True)),
                (
                    "dose",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_dose",
                        to="base.quantity",
                    ),
                ),
                (
                    "method",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_method",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "rate_quantity",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_rate_quantity",
                        to="base.quantity",
                    ),
                ),
                (
                    "rate_ratio",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_rate_ratio",
                        to="base.ratio",
                    ),
                ),
                (
                    "route",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_route",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="medication_administration_dosage_site",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="dosage",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_dosage",
                to="medicationadministrations.medicationadministrationdosage",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_encounter",
                to="encounters.encounterreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="medication",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_medication_codeable_reference",
                to="medications.medicationcodeablereference",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="note",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_note",
                to="base.annotation",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="occurrence_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_occurrence_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="part_of",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_part_of",
                to="medicationadministrations.medicationadministrationpartof",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="performer",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_performer",
                to="medicationadministrations.medicationadministrationperformer",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_reason_codeable_reference",
                to="medicationadministrations.medicationadministrationreasoncodeablereference",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="request",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_request",
                to="medicationrequests.medicationrequestreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="status_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_status_reason",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="sub_potent_reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="medication_administration_sub_potent_reason",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="medication_administration_subject",
                to="patients.patientgroupreference",
            ),
        ),
        migrations.AddField(
            model_name="medicationadministration",
            name="supporting_information",
            field=models.ManyToManyField(
                related_name="medication_administration_supporting_information",
                to="base.reference",
            ),
        ),
    ]
