# Generated by Django 4.2.14 on 2025-01-06 22:48

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('status', models.CharField(choices=[('active', 'Active'), ('suspended', 'Suspended'), ('inactive', 'Inactive')], default='active', max_length=255)),
                ('alias', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('description', models.TextField(null=True)),
                ('mode', models.CharField(choices=[('instance', 'Instance'), ('kind', 'Kind')], max_length=255, null=True)),
                ('address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.address')),
                ('characteristic', models.ManyToManyField(blank=True, related_name='location_characteristic', to='base.codeableconcept')),
                ('contact', models.ManyToManyField(blank=True, related_name='location_contact', to='base.extendedcontactdetail')),
                ('endpoint', models.ManyToManyField(blank=True, related_name='location_endpoint', to='base.endpointreference')),
                ('form', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_form', to='base.codeableconcept')),
                ('hours_of_operation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.availability')),
                ('identifier', models.ManyToManyField(blank=True, related_name='location_identifier', to='base.identifier')),
                ('managing_organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_organization', to='base.organizationreference')),
                ('operational_status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_operational_status', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('longitude', models.FloatField()),
                ('latitude', models.FloatField()),
                ('altitude', models.FloatField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LocationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_reference', to='locations.location')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='location',
            name='part_of',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='location_part_of', to='locations.locationreference'),
        ),
        migrations.AddField(
            model_name='location',
            name='position',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='locations.position'),
        ),
        migrations.AddField(
            model_name='location',
            name='type',
            field=models.ManyToManyField(blank=True, related_name='location_type', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='location',
            name='virtual_service_details',
            field=models.ManyToManyField(blank=True, related_name='location_virtual_service_details', to='base.virtualservicedetails'),
        ),
    ]
