# Generated by Django 4.2.14 on 2025-02-24 12:33

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('patients', '0007_patientorganizationreference'),
        ('devices', '0007_alter_device_status_and_more'),
        ('accounts', '0007_account_billing_status_account_currency'),
        ('base', '0014_monetarycomponent'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
    ]

    operations = [
        migrations.CreateModel(
            name='InvoiceRecipientReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_recipient_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_recipient_reference_organization', to='base.organizationreference')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_recipient_reference_patient', to='patients.patient')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_recipient_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InvoiceParticipantActorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_organization', to='base.organizationreference')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InvoiceParticipant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('actor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_actor', to='invoices.invoiceparticipantactorreference')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_participant_role', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InvoiceLineItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField(null=True)),
                ('service_date', models.DateField(null=True)),
                ('charge_item_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_line_item_charge_item_codeable_concept', to='base.codeableconcept')),
                ('price_component', models.ManyToManyField(blank=True, related_name='invoice_line_item_price_component', to='base.monetarycomponent')),
                ('service_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_line_item_service_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('issued', 'Issued'), ('balanced', 'Balanced'), ('cancelled', 'Cancelled'), ('entered_in_error', 'Entered in error')], default='draft', max_length=255)),
                ('cancelled_reason', models.TextField(null=True)),
                ('date', models.DateTimeField(null=True)),
                ('creation', models.DateTimeField(null=True)),
                ('period_date', models.DateField(null=True)),
                ('payment_terms', models.TextField(null=True)),
                ('account', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_account', to='accounts.accountreference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='invoice_identifier', to='base.identifier')),
                ('issuer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_issuer', to='base.organizationreference')),
                ('line_item', models.ManyToManyField(blank=True, related_name='invoice_line_item', to='invoices.invoicelineitem')),
                ('note', models.ManyToManyField(blank=True, related_name='invoice_note', to='base.annotation')),
                ('participant', models.ManyToManyField(blank=True, related_name='invoice_participant', to='invoices.invoiceparticipant')),
                ('period_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_period_period', to='base.period')),
                ('recipient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_recipient', to='invoices.invoicerecipientreference')),
                ('subject', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_subject', to='patients.patientgroupreference')),
                ('total_gross', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_total_gross', to='base.money')),
                ('total_net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_total_net', to='base.money')),
                ('total_price_component', models.ManyToManyField(blank=True, related_name='invoice_total_price_component', to='base.monetarycomponent')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='invoice_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
