# Generated by Django 4.2.14 on 2025-03-13 16:50

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("devices", "0007_alter_device_status_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("nutritionproducts", "0003_remove_nutritionproductnutrients_allergen"),
        ("inventoryitems", "0002_alter_inventoryitem_identifier"),
        ("practitioners", "0011_practitionerrolereference"),
        ("locations", "0006_merge_20250129_1542"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("base", "0018_merge_20250307_1944"),
        ("biologicallyderivedproducts", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="InventoryReportReporterReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_reporter_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_reporter_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_reporter_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_reporter_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_reporter_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="InventoryReportInventoryListingItemItemReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_derived_product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_biologically_derived_product",
                        to="biologicallyderivedproducts.biologicallyderivedproduct",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "inventory_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_inventory_item",
                        to="inventoryitems.inventoryitem",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "nutrition_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_nutrition_product",
                        to="nutritionproducts.nutritionproduct",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="InventoryReportInventoryListingItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "category",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_category",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "item",
                    models.ManyToManyField(
                        blank=True,
                        related_name="inventory_report_inventory_listing_item",
                        to="inventoryreports.inventoryreportinventorylistingitemitemreference",
                    ),
                ),
                (
                    "quality",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_quality",
                        to="base.quantity",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="InventoryReportInventoryListing",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("continuing_date_time", models.DateTimeField(null=True)),
                (
                    "item_status",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing_item_status",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_inventory_listing",
                        to="locations.locationreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="InventoryReport",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("requested", "Requested"),
                            ("active", "Active"),
                            ("entered-in-error", "Entered In Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "count_type",
                    models.CharField(
                        choices=[
                            ("snapshot", "Snapshot"),
                            ("difference", "Difference"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("reported_date_time", models.DateTimeField(null=True)),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="inventory_report",
                        to="base.identifier",
                    ),
                ),
                (
                    "inventory_listing",
                    models.ManyToManyField(
                        blank=True,
                        related_name="inventory_report",
                        to="inventoryreports.inventoryreportinventorylisting",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="inventory_report",
                        to="base.annotation",
                    ),
                ),
                (
                    "operation_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_operational_type",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "operation_type_reason",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report_operational_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "reporter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report",
                        to="inventoryreports.inventoryreportreporterreference",
                    ),
                ),
                (
                    "reporting_period",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="inventory_report",
                        to="base.period",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
