# Generated by Django 4.2.14 on 2025-01-31 15:12

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('medications', '0004_medicationreference_medicationcodeablereference'),
        ('base', '0010_expression_relativetime'),
        ('patients', '0007_patientorganizationreference'),
        ('locations', '0006_merge_20250129_1542'),
        ('devicedefinitions', '0002_devicedefinitiondeviceversion_and_more'),
        ('devices', '0007_alter_device_status_and_more'),
        ('organizations', '0003_organization_endpoint'),
    ]

    operations = [
        migrations.CreateModel(
            name='InventoryItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemDescription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('language', models.CharField(choices=[('ar', 'Arabic'), ('bg', 'Bulgarian'), ('bg-BG', 'Bulgarian (Bulgaria)'), ('bn', 'Bengali'), ('cs', 'Czech'), ('cs-CZ', 'Czech (Czechia)'), ('bs', 'Bosnian'), ('bs-BA', 'Bosnian (Bosnia and Herzegovina)'), ('da', 'Danish'), ('da-DK', 'Danish (Denmark)'), ('de', 'German'), ('de-AT', 'German (Austria)'), ('de-CH', 'German (Switzerland)'), ('de-DE', 'German (Germany)'), ('el', 'Greek'), ('el-GR', 'Greek (Greece)'), ('en', 'English'), ('en-AU', 'English (Australia)'), ('en-CA', 'English (Canada)'), ('en-GB', 'English (Great Britain)'), ('en-IN', 'English (India)'), ('en-NZ', 'English (New Zealand)'), ('en-SG', 'English (Singapore)'), ('en-US', 'English (United States)'), ('es', 'Spanish'), ('es-AR', 'Spanish (Argentina)'), ('es-ES', 'Spanish (Spain)'), ('es-UY', 'Spanish (Uruguay)'), ('et', 'Estonian'), ('et-EE', 'Estonian (Estonia)'), ('fi', 'Finnish'), ('fr', 'French'), ('fr-BE', 'French (Belgium)'), ('fr-CH', 'French (Switzerland)'), ('fr-FR', 'French (France)'), ('fi-FI', 'Finnish (Finland)'), ('fr-CA', 'French (Canada)'), ('fy', 'Frisian'), ('fy-NL', 'Frisian (Netherlands)'), ('hi', 'Hindi'), ('hr', 'Croatian'), ('hr-HR', 'Croatian (Croatia)'), ('is', 'Icelandic'), ('is-IS', 'Icelandic (Iceland)'), ('it', 'Italian'), ('it-CH', 'Italian (Switzerland)'), ('it-IT', 'Italian (Italy)'), ('ja', 'Japanese'), ('ko', 'Korean'), ('lt', 'Lithuanian'), ('lt-LT', 'Lithuanian (Lithuania)'), ('lv', 'Latvian'), ('lv-LV', 'Latvian (Latvia)'), ('nl', 'Dutch'), ('nl-BE', 'Dutch (Belgium)'), ('nl-NL', 'Dutch (Netherlands)'), ('no', 'Norwegian'), ('no-NO', 'Norwegian (Norway)'), ('pa', 'Punjabi'), ('pl', 'Polish'), ('pl-PL', 'Polish (Poland)'), ('pt', 'Portuguese'), ('pt-PT', 'Portuguese (Portugal)'), ('pt-BR', 'Portuguese (Brazil)'), ('ro', 'Romanian'), ('ro-RO', 'Romanian (Romania)'), ('ru', 'Russian'), ('ru-RU', 'Russian (Russia)'), ('sk', 'Slovakian'), ('sk-SK', 'Slovakian (Slovakia)'), ('sl', 'Slovenian'), ('sl-SI', 'Slovenian (Slovenia)'), ('sr', 'Serbian'), ('sr-RS', 'Serbian (Serbia)'), ('sv', 'Swedish'), ('sv-SE', 'Swedish (Sweden)'), ('te', 'Telugu'), ('zh', 'Chinese'), ('zh-CN', 'Chinese (China)'), ('zh-HK', 'Chinese (Hong Kong)'), ('zh-SG', 'Chinese (Singapore)'), ('zh-TW', 'Chinese (Taiwan)')], max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name_type', models.CharField(choices=[('trade_name', 'Trade Name'), ('alias', 'Alias'), ('original_name', 'Original Name'), ('preferred', 'Preferred')], max_length=255, null=True)),
                ('language', models.CharField(choices=[('ar', 'Arabic'), ('bg', 'Bulgarian'), ('bg-BG', 'Bulgarian (Bulgaria)'), ('bn', 'Bengali'), ('cs', 'Czech'), ('cs-CZ', 'Czech (Czechia)'), ('bs', 'Bosnian'), ('bs-BA', 'Bosnian (Bosnia and Herzegovina)'), ('da', 'Danish'), ('da-DK', 'Danish (Denmark)'), ('de', 'German'), ('de-AT', 'German (Austria)'), ('de-CH', 'German (Switzerland)'), ('de-DE', 'German (Germany)'), ('el', 'Greek'), ('el-GR', 'Greek (Greece)'), ('en', 'English'), ('en-AU', 'English (Australia)'), ('en-CA', 'English (Canada)'), ('en-GB', 'English (Great Britain)'), ('en-IN', 'English (India)'), ('en-NZ', 'English (New Zealand)'), ('en-SG', 'English (Singapore)'), ('en-US', 'English (United States)'), ('es', 'Spanish'), ('es-AR', 'Spanish (Argentina)'), ('es-ES', 'Spanish (Spain)'), ('es-UY', 'Spanish (Uruguay)'), ('et', 'Estonian'), ('et-EE', 'Estonian (Estonia)'), ('fi', 'Finnish'), ('fr', 'French'), ('fr-BE', 'French (Belgium)'), ('fr-CH', 'French (Switzerland)'), ('fr-FR', 'French (France)'), ('fi-FI', 'Finnish (Finland)'), ('fr-CA', 'French (Canada)'), ('fy', 'Frisian'), ('fy-NL', 'Frisian (Netherlands)'), ('hi', 'Hindi'), ('hr', 'Croatian'), ('hr-HR', 'Croatian (Croatia)'), ('is', 'Icelandic'), ('is-IS', 'Icelandic (Iceland)'), ('it', 'Italian'), ('it-CH', 'Italian (Switzerland)'), ('it-IT', 'Italian (Italy)'), ('ja', 'Japanese'), ('ko', 'Korean'), ('lt', 'Lithuanian'), ('lt-LT', 'Lithuanian (Lithuania)'), ('lv', 'Latvian'), ('lv-LV', 'Latvian (Latvia)'), ('nl', 'Dutch'), ('nl-BE', 'Dutch (Belgium)'), ('nl-NL', 'Dutch (Netherlands)'), ('no', 'Norwegian'), ('no-NO', 'Norwegian (Norway)'), ('pa', 'Punjabi'), ('pl', 'Polish'), ('pl-PL', 'Polish (Poland)'), ('pt', 'Portuguese'), ('pt-PT', 'Portuguese (Portugal)'), ('pt-BR', 'Portuguese (Brazil)'), ('ro', 'Romanian'), ('ro-RO', 'Romanian (Romania)'), ('ru', 'Russian'), ('ru-RU', 'Russian (Russia)'), ('sk', 'Slovakian'), ('sk-SK', 'Slovakian (Slovakia)'), ('sl', 'Slovenian'), ('sl-SI', 'Slovenian (Slovenia)'), ('sr', 'Serbian'), ('sr-RS', 'Serbian (Serbia)'), ('sv', 'Swedish'), ('sv-SE', 'Swedish (Sweden)'), ('te', 'Telugu'), ('zh', 'Chinese'), ('zh-CN', 'Chinese (China)'), ('zh-HK', 'Chinese (Hong Kong)'), ('zh-SG', 'Chinese (Singapore)'), ('zh-TW', 'Chinese (Taiwan)')], max_length=255, null=True)),
                ('name', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemResponsibleOrganization',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='inventory_item_responsible_organization_codes', to='base.codeableconcept')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_responsible_organization_organizations', to='organizations.organization')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_references_identifiers', to='base.identifier')),
                ('inventory_item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_references_inventory_items', to='inventoryitems.inventoryitem')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemProductReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_product_reference_devices', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_product_reference_identifiers', to='base.identifier')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_product_reference_medications', to='medications.medication')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemInstance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('lot_number', models.CharField(max_length=255, null=True)),
                ('expiry', models.DateTimeField(null=True)),
                ('identifier', models.ManyToManyField(blank=True, related_name='inventory_item_instances', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_instances_locations', to='locations.locationreference')),
                ('subject', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_instances_subjects', to='patients.patientorganizationreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemCharacteristic',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('value_integer', models.IntegerField(null=True)),
                ('value_decimal', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_url', models.URLField(null=True)),
                ('value_date_time', models.DateTimeField(null=True)),
                ('characteristic_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_characteristic_types', to='base.codeableconcept')),
                ('value_annotation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_annotations', to='base.annotation')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_codeable_concepts', to='base.codeableconcept')),
                ('value_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_durations', to='base.quantity')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_quantities', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_ranges', to='base.range')),
                ('value_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_characteristics_value_ratios', to='base.ratio')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemAssociationTypeReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='association_type_reference_devices', to='devices.device')),
                ('device_definition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='association_type_reference_device_definitions', to='devicedefinitions.devicedefinition')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='association_type_reference_identifiers', to='base.identifier')),
                ('inventor_item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='association_type_reference_inventory_items', to='inventoryitems.inventoryitem')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='association_type_reference_medications', to='medications.medication')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryItemAssociation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('association_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='inventory_item_associations_association_types', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_associations_quantity', to='base.ratio')),
                ('related_item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_item_associations_related_items', to='inventoryitems.inventoryitemassociationtypereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='association',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_associations', to='inventoryitems.inventoryitemassociation'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='base_unit',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_items_base_units', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='category',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_categories', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='characteristic',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_characteristics', to='inventoryitems.inventoryitemcharacteristic'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='code',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_codes', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='description',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_items_descriptions', to='inventoryitems.inventoryitemdescription'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='inventory_items', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='instance',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_items_insurances', to='inventoryitems.inventoryiteminstance'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='inventory_status',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_inventory_statuses', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='name',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_names', to='inventoryitems.inventoryitemname'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='net_content',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_items_net_contents', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='product_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='inventory_items_product_references', to='inventoryitems.inventoryitemproductreference'),
        ),
        migrations.AddField(
            model_name='inventoryitem',
            name='responsible_organization',
            field=models.ManyToManyField(blank=True, related_name='inventory_items_responsible_organizations', to='inventoryitems.inventoryitemresponsibleorganization'),
        ),
    ]
