"""inventory items model choices."""

from django.db.models import TextChoices
from django.utils.translation import gettext_lazy as _


class InventoryItemNameTypeChoices(TextChoices):
    """inventory item name type choices."""

    TREADE_NAME = "trade_name", _("Trade Name")
    ALIAS = "alias", _("Alias")
    ORIGINAL_NAME = "original_name", _("Original Name")
    PREFERRED = "preferred", _("Preferred")


class InventoryItemNameLanguageChoices(TextChoices):
    """inventory item name language choices."""

    AR = "ar", _("Arabic")
    BG = "bg", _("Bulgarian")
    BG_BG = "bg-BG", _("Bulgarian (Bulgaria)")
    BN = "bn", _("Bengali")
    CS = "cs", _("Czech")
    CS_CZ = "cs-CZ", _("Czech (Czechia)")
    BS = "bs", _("Bosnian")
    BS_BA = "bs-BA", _("Bosnian (Bosnia and Herzegovina)")
    DA = "da", _("Danish")
    DA_DK = "da-DK", _("Danish (Denmark)")
    DE = "de", _("German")
    DE_AT = "de-AT", _("German (Austria)")
    DE_CH = "de-CH", _("German (Switzerland)")
    DE_DE = "de-DE", _("German (Germany)")
    EL = "el", _("Greek")
    EL_GR = "el-GR", _("Greek (Greece)")
    EN = "en", _("English")
    EN_AU = "en-AU", _("English (Australia)")
    EN_CA = "en-CA", _("English (Canada)")
    EN_GB = "en-GB", _("English (Great Britain)")
    EN_IN = "en-IN", _("English (India)")
    EN_NZ = "en-NZ", _("English (New Zealand)")
    EN_SG = "en-SG", _("English (Singapore)")
    EN_US = "en-US", _("English (United States)")
    ES = "es", _("Spanish")
    ES_AR = "es-AR", _("Spanish (Argentina)")
    ES_ES = "es-ES", _("Spanish (Spain)")
    ES_UY = "es-UY", _("Spanish (Uruguay)")
    ET = "et", _("Estonian")
    ET_EE = "et-EE", _("Estonian (Estonia)")
    FI = "fi", _("Finnish")
    FR = "fr", _("French")
    FR_BE = "fr-BE", _("French (Belgium)")
    FR_CH = "fr-CH", _("French (Switzerland)")
    FR_FR = "fr-FR", _("French (France)")
    FI_FI = "fi-FI", _("Finnish (Finland)")
    FR_CA = "fr-CA", _("French (Canada)")
    FY = "fy", _("Frisian")
    FY_NL = "fy-NL", _("Frisian (Netherlands)")
    HI = "hi", _("Hindi")
    HR = "hr", _("Croatian")
    HR_HR = "hr-HR", _("Croatian (Croatia)")
    IS = "is", _("Icelandic")
    IS_IS = "is-IS", _("Icelandic (Iceland)")
    IT = "it", _("Italian")
    IT_CH = "it-CH", _("Italian (Switzerland)")
    IT_IT = "it-IT", _("Italian (Italy)")
    JA = "ja", _("Japanese")
    KO = "ko", _("Korean")
    LT = "lt", _("Lithuanian")
    LT_LT = "lt-LT", _("Lithuanian (Lithuania)")
    LV = "lv", _("Latvian")
    LV_LV = "lv-LV", _("Latvian (Latvia)")
    NL = "nl", _("Dutch")
    NL_BE = "nl-BE", _("Dutch (Belgium)")
    NL_NL = "nl-NL", _("Dutch (Netherlands)")
    NO = "no", _("Norwegian")
    NO_NO = "no-NO", _("Norwegian (Norway)")
    PA = "pa", _("Punjabi")
    PL = "pl", _("Polish")
    PL_PL = "pl-PL", _("Polish (Poland)")
    PT = "pt", _("Portuguese")
    PT_PT = "pt-PT", _("Portuguese (Portugal)")
    PT_BR = "pt-BR", _("Portuguese (Brazil)")
    RO = "ro", _("Romanian")
    RO_RO = "ro-RO", _("Romanian (Romania)")
    RU = "ru", _("Russian")
    RU_RU = "ru-RU", _("Russian (Russia)")
    SK = "sk", _("Slovakian")
    SK_SK = "sk-SK", _("Slovakian (Slovakia)")
    SL = "sl", _("Slovenian")
    SL_SI = "sl-SI", _("Slovenian (Slovenia)")
    SR = "sr", _("Serbian")
    SR_RS = "sr-RS", _("Serbian (Serbia)")
    SV = "sv", _("Swedish")
    SV_SE = "sv-SE", _("Swedish (Sweden)")
    TE = "te", _("Telugu")  # codespell:ignore
    ZH = "zh", _("Chinese")
    ZH_CN = "zh-CN", _("Chinese (China)")
    ZH_HK = "zh-HK", _("Chinese (Hong Kong)")
    ZH_SG = "zh-SG", _("Chinese (Singapore)")
    ZH_TW = "zh-TW", _("Chinese (Taiwan)")


class InventoryItemStatusChoices(TextChoices):
    """inventory item status choices."""

    ACTIVE = "active", _("Active")
    INACTIVE = "inactive", _("Inactive")
    DRAFT = "draft", _("Draft")
    ENTERED_IN_ERROR = "entered-in-error", _("Entered in Error")
    UNKNOWN = "unknown", _("Unknown")
