# Generated by Django 4.2.14 on 2025-02-25 19:51

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("base", "0014_organizationcodeableconcept"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("observations", "0008_alter_observationcodeablereference_concept_and_more"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("locations", "0006_merge_20250129_1542"),
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
        ("careplans", "0005_careplanaddressescodeablereference_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("patients", "0007_patientorganizationreference"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("organizations", "0003_organization_endpoint"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImmunizationReaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("date", models.DateTimeField(null=True)),
                ("reported", models.BooleanField(default=False)),
                (
                    "manifestation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_reaction_detail",
                        to="observations.observationreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationProtocolApplied",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("series", models.CharField(max_length=255, null=True)),
                ("dose_number", models.CharField(max_length=255, null=True)),
                ("series_dose", models.CharField(max_length=255, null=True)),
                (
                    "authority",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_protocol_applied_authority",
                        to="base.organizationreference",
                    ),
                ),
                (
                    "usage_disease",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_protocol_applied_usage_disease",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationProgramEligibility",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "program",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_program_eligibility_program",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "program_status",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_program_eligibility_program_status",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performer_actor_references",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performers",
                        to="immunizations.immunizationperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_performers",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationInformationSourceRefrence",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source_references",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImmunizationBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_based_on_references",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_based_on_references",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_based_on_references",
                        to="medicationrequests.medicationrequest",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_based_on_references",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Immunization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in Error"),
                            ("not-done", "Not Done"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("lot_number", models.CharField(max_length=255, null=True)),
                ("expiration_date", models.DateTimeField(null=True)),
                ("occurrence_date_time", models.DateTimeField(null=True)),
                ("occurrence_string", models.CharField(max_length=255, null=True)),
                ("primary_source", models.BooleanField(default=False)),
                ("is_subpotent", models.BooleanField(default=False)),
                (
                    "administered_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_administered_product",
                        to="medications.medicationcodeablereference",
                    ),
                ),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_based_on",
                        to="immunizations.immunizationbasedonreference",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
                (
                    "funding_source",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_funding_source",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "information_source",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_information_source",
                        to="immunizations.immunizationinformationsourcerefrence",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_location",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_patient",
                        to="patients.patientreference",
                    ),
                ),
                (
                    "program_eligibility",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_program_eligibility",
                        to="immunizations.immunizationprogrameligibility",
                    ),
                ),
                (
                    "protocol_applied",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_protocol_applied",
                        to="immunizations.immunizationprotocolapplied",
                    ),
                ),
                (
                    "reaction",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_reaction",
                        to="immunizations.immunizationreaction",
                    ),
                ),
                (
                    "reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_site",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "status_reason",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_status_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "subpotent_reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_subpotent_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "supporting_infortmation",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_supporting_infortmation",
                        to="base.reference",
                    ),
                ),
                (
                    "vaccine_code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_vaccine_code",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
