"""immunization serializers."""

from nebula.base.serializers import (
    BaseWritableNestedModelSerializer,
    CodeableConceptSerializer,
    IdentifierSerializer,
    OrganizationReferenceSerializer,
)
from nebula.immunizationevaluations.models import ImmunizationEvaluation
from nebula.patients.serializers import PatientReferenceSerializer


class ImmunizationEvaluationSerializer(BaseWritableNestedModelSerializer):
    """immunization evaluation serializer."""

    identifier = IdentifierSerializer(many=True, required=False)
    patient = PatientReferenceSerializer(many=False, required=False)
    authority = OrganizationReferenceSerializer(many=False, required=False)
    target_disease = CodeableConceptSerializer(many=False, required=False)
    dose_status = CodeableConceptSerializer(many=False, required=False)
    dose_status_reason = CodeableConceptSerializer(many=True, required=False)

    class Meta:
        """meta class."""

        model = ImmunizationEvaluation
        exclude = ["created_at", "updated_at"]
