# Generated by Django 4.2.14 on 2025-02-26 01:13

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("base", "0013_money"),
        ("patients", "0007_patientorganizationreference"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImmunizationEvaluation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("completed", "Completed"),
                            ("entered-in-error", "Entered in Error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("date", models.DateTimeField(null=True)),
                ("description", models.TextField(null=True)),
                ("series", models.CharField(max_length=255, null=True)),
                ("dose_number", models.CharField(max_length=255, null=True)),
                ("series_doses", models.CharField(max_length=255, null=True)),
                (
                    "authority",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_evaluation_authority",
                        to="base.organizationreference",
                    ),
                ),
                (
                    "dose_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_evaluation_dose_status",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "dose_status_reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_evaluation_dose_status_reason",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="immunization_evaluation_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_evaluation_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "target_disease",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="immunization_evaluation_target_disease",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
