# Generated by Django 4.2.14 on 2025-02-21 14:50

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("observations", "0008_alter_observationcodeablereference_concept_and_more"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("appointments", "0008_appointment_based_on_appointment_reason_and_more"),
        ("endpoints", "0006_alter_endpoint_connection_type"),
        ("specimens", "0002_rename_specimencollections_specimencollection_and_more"),
        (
            "documentreferences",
            "0003_rename_base_on_documentreference_based_on_and_more",
        ),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("diagnosticreports", "0005_diagnosticreportdocumentreferencereference"),
        ("base", "0013_money"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("bodystructures", "0006_bodystructurecodeablereference"),
        ("careplans", "0005_careplanaddressescodeablereference_and_more"),
        ("organizations", "0003_organization_endpoint"),
        ("patients", "0007_patientorganizationreference"),
        ("devices", "0007_alter_device_status_and_more"),
        ("locations", "0006_merge_20250129_1542"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("conditions", "0006_merge_20250217_1423"),
        ("procedures", "0008_merge_20250218_1723"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImagingStudySeriesInstance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("uid", models.CharField(max_length=255)),
                ("sop_class", models.CharField(max_length=255, null=True)),
                ("number", models.IntegerField(null=True)),
                ("title", models.CharField(max_length=255, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudySubjectReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_subject_reference",
                        to="devices.device",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_subject_reference",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_subject_reference",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_subject_reference",
                        to="patients.patient",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudySeriesPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudySeriesPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="imagingstudy.imagingstudyseriesperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_performer_reference",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudySeries",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("uid", models.CharField(max_length=255, null=True)),
                ("number", models.IntegerField(null=True)),
                ("description", models.CharField(max_length=255, null=True)),
                ("number_of_instances", models.IntegerField(null=True)),
                ("started", models.DateTimeField(null=True)),
                (
                    "body_site",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_body_site",
                        to="bodystructures.bodystructurecodeablereference",
                    ),
                ),
                (
                    "endpoint",
                    models.ManyToManyField(
                        related_name="imaging_study_series_endpoint",
                        to="endpoints.endpointreference",
                    ),
                ),
                (
                    "instance",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_series_instance",
                        to="imagingstudy.imagingstudyseriesinstance",
                    ),
                ),
                (
                    "laterality",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_laterality",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "modality",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_series_modality",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "performer",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_series_performer",
                        to="imagingstudy.imagingstudyseriesperformer",
                    ),
                ),
                (
                    "specimen",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_series_specimen",
                        to="specimens.specimenreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudyReasonReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_reason",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_reason",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "document_reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_reason",
                        to="documentreferences.documentreference",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_reason",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_reason",
                        to="observations.observation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudyProcedureReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_procedure_reference",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudyBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "appointment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_based_on_reference",
                        to="appointments.appointment",
                    ),
                ),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_based_on_reference",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_based_on_reference",
                        to="base.identifier",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_based_on_reference",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingStudy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("registered", "Registered"),
                            ("available", "Available"),
                            ("cancelled", "Cancelled"),
                            ("entered-in-error", "Entered in error"),
                            ("unknown", "Unknown"),
                            ("inactive", "Inactive"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("started", models.DateTimeField(null=True)),
                ("description", models.CharField(max_length=255, null=True)),
                ("number_of_series", models.IntegerField(null=True)),
                ("number_of_instances", models.IntegerField(null=True)),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_based_on",
                        to="imagingstudy.imagingstudybasedonreference",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
                (
                    "endpoint",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_endpoint",
                        to="endpoints.endpointreference",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_location",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "modality",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_modality",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "part_of",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_part_of",
                        to="procedures.procedurereference",
                    ),
                ),
                (
                    "procedure",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_procedure",
                        to="imagingstudy.imagingstudyprocedurereference",
                    ),
                ),
                (
                    "reason",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_reason",
                        to="imagingstudy.imagingstudyreasonreference",
                    ),
                ),
                (
                    "referrer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_referrer",
                        to="practitioners.practitionerpractitionerrolereference",
                    ),
                ),
                (
                    "series",
                    models.ManyToManyField(
                        blank=True,
                        related_name="imaging_study_series",
                        to="imagingstudy.imagingstudyseries",
                    ),
                ),
                (
                    "subject",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_study_subject",
                        to="imagingstudy.imagingstudysubjectreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
