# Generated by Django 4.2.14 on 2025-02-26 13:48

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("endpoints", "0006_alter_endpoint_connection_type"),
        ("organizations", "0003_organization_endpoint"),
        ("devices", "0007_alter_device_status_and_more"),
        ("base", "0013_money"),
        (
            "bodystructures",
            "0005_remove_bodystructure_imaging_bodystructure_image_and_more",
        ),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("specimens", "0002_rename_specimencollections_specimencollection_and_more"),
        ("procedures", "0008_merge_20250218_1723"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("careplans", "0005_careplanaddressescodeablereference_and_more"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("appointments", "0008_appointment_based_on_appointment_reason_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("substances", "0002_substancecodeablereference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("imagingselections", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="ImagingSelectionImageRegion3D",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "region_type",
                    models.CharField(
                        choices=[
                            ("point", "Point"),
                            ("multipoint", "Multipoint"),
                            ("polyline", "Polyline"),
                            ("polygon", "Polygon"),
                            ("ellipse", "Ellipse"),
                            ("ellipsoid", "Ellipsoid"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "coordinate",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.FloatField(null=True), null=True, size=None
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingSelectionInstanceImagingRegion2D",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "region_type",
                    models.CharField(
                        choices=[
                            ("point", "Point"),
                            ("polyline", "Polyline"),
                            ("multipoint", "Multipoint"),
                            ("circle", "Circle"),
                            ("ellipse", "Ellipse"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "coordinate",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.FloatField(null=True), null=True, size=None
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="bodysite",
            field=models.ManyToManyField(
                blank=True,
                related_name="imaging_selection_bodysite",
                to="bodystructures.bodystructurereference",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="category",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_category",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="code",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="image_selection_code",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="endpoint",
            field=models.ManyToManyField(
                blank=True,
                related_name="imaging_selection_endpoint",
                to="endpoints.endpointreference",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="focus",
            field=models.ManyToManyField(
                blank=True,
                related_name="imaging_selection_focus",
                to="imagingselections.imagingselectionreference",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="frame_of_reference_uid",
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="issues",
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="series_number",
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="series_uid",
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="status",
            field=models.CharField(
                choices=[
                    ("available", "Available"),
                    ("entered-in-error", "Entered in Error"),
                    ("inactive", "Inactive"),
                    ("unknown", "Unknown"),
                ],
                max_length=255,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="study_uid",
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.CreateModel(
            name="ImagingSelectionSubjectReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_group",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_patient",
                        to="patients.patientreference",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
                (
                    "specimen",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_specimen",
                        to="specimens.specimen",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_subject_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingSelectionPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_care_team",
                        to="careteams.careteamreference",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_healthcare_service",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_patient",
                        to="patients.patientreference",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_actor_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingSelectionPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_performer_actor",
                        to="imagingselections.imagingselectionperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="imaging_selection_performer_function",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingSelectionInstance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("uid", models.CharField(max_length=255, null=True)),
                ("number", models.IntegerField(null=True)),
                ("sop_class", models.CharField(max_length=255, null=True)),
                (
                    "subset",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=255, null=True),
                        null=True,
                        size=None,
                    ),
                ),
                (
                    "imaging_region_2d",
                    models.ManyToManyField(
                        blank=True,
                        related_name="image_selection_instance_imaging_region_2d",
                        to="imagingselections.imagingselectioninstanceimagingregion2d",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ImagingSelectionBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "appointment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="image_selection_based_on_reference_appointment",
                        to="appointments.appointment",
                    ),
                ),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="image_selection_based_on_reference_care_plan",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="image_selection_based_on_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="image_selection_based_on_reference_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="based_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_based_on",
                to="imagingselections.imagingselectionbasedonreference",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="image_region_3d",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_image_region_3d",
                to="imagingselections.imagingselectionimageregion3d",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="instance",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_instance",
                to="imagingselections.imagingselectioninstance",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="performer",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_performer",
                to="imagingselections.imagingselectionperformer",
            ),
        ),
        migrations.AddField(
            model_name="imagingselection",
            name="subject",
            field=models.ManyToManyField(
                blank=True,
                related_name="image_selection_subject",
                to="imagingselections.imagingselectionsubjectreference",
            ),
        ),
    ]
