# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('locations', '0001_initial'),
        ('base', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClinicalSpecialty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HealthcareService',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('active', models.BooleanField(default=True)),
                ('name', models.CharField(max_length=255)),
                ('comment', models.TextField(null=True)),
                ('extra_details', models.TextField(null=True)),
                ('referral_required', models.BooleanField(default=False)),
                ('appointment_required', models.BooleanField(default=False)),
                ('availability', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='healthcareservice_availability', to='base.availability')),
                ('category', models.ManyToManyField(blank=True, related_name='healthcareservice_category', to='base.codeableconcept')),
                ('characteristic', models.ManyToManyField(blank=True, related_name='healthcareservice_characteristics', to='base.codeableconcept')),
                ('communication', models.ManyToManyField(blank=True, related_name='healthcareservice_communication', to='base.codeableconcept')),
                ('contact', models.ManyToManyField(blank=True, related_name='healthcareservice_contact', to='base.extendedcontactdetail')),
                ('coverage_area', models.ManyToManyField(blank=True, related_name='healthcareservice_coverage_area', to='locations.locationreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ServiceType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='HealthCareServiceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('healthcareservice', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='healthcareservice_reference', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='healthcareservice_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HealthCareServiceEligibilityValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.codeableconcept')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.range')),
                ('value_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HealthcareServiceEligibility',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('comment', models.TextField(null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='healthcareserviceeligibility_code', to='base.codeableconcept')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.period')),
                ('value', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='healthcareservices.healthcareserviceeligibilityvalue')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HealthCareServiceCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='codeable_reference_code', to='base.codeableconcept')),
                ('healthcareservice', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='codeable_reference_healthcareservice', to='healthcareservices.healthcareservice')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='codeable_reference', to='healthcareservices.healthcareservicereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='eligibility',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_eligibility', to='healthcareservices.healthcareserviceeligibility'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='endpoint',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_endpoint', to='base.endpoint'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='location',
            field=models.ManyToManyField(blank=True, related_name='healthcare_service_location', to='locations.locationreference'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='offered_in',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_offered_in', to='healthcareservices.healthcareservicereference'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='photo',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='base.attachment'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='program',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_program', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='provided_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='referral_method',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_referral_method', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='service_provision_code',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_service_provision_code', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='specialty',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_specialty', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='healthcareservice',
            name='type',
            field=models.ManyToManyField(blank=True, related_name='healthcareservice_type', to='base.codeableconcept'),
        ),
    ]
