# Generated by Django 4.2.14 on 2025-01-30 10:55

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('healthcareservices', '0006_remove_healthcareservice_endpoint'),
        ('base', '0010_expression_relativetime'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('devices', '0007_alter_device_status_and_more'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('patients', '0006_patientgroupreference_group_and_more'),
        ('organizations', '0003_organization_endpoint'),
        ('locations', '0006_merge_20250129_1542'),
        ('devicedefinitions', '0002_devicedefinitiondeviceversion_and_more'),
        ('devicemetrics', '0002_alter_devicemetric_operational_status_and_more'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('groups', '0003_delete_groupspecimenreference'),
    ]

    operations = [
        migrations.AddField(
            model_name='group',
            name='code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_code', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='group',
            name='combination_method',
            field=models.CharField(choices=[('all-of', 'All Of'), ('any-of', 'Any Of'), ('at-least', 'At Least'), ('at-most', 'At Most'), ('except-subset', 'Except Subset')], max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='combination_threshold',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='contact',
            field=models.ManyToManyField(blank=True, related_name='group_contact', to='base.contactdetail'),
        ),
        migrations.AddField(
            model_name='group',
            name='copyright',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='copyright_label',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='date',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='description',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='experimental',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='group',
            name='membership',
            field=models.CharField(choices=[('definitional', 'Definitional'), ('conceptual', 'Conceptual'), ('enumerated', 'Enumerated')], max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='name',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='publisher',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='purpose',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='quantity',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('active', 'Active'), ('retired', 'Retired'), ('unknown', 'Unknown')], max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='title',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='type',
            field=models.CharField(choices=[('person', 'Person'), ('animal', 'Animal'), ('practitioner', 'Practitioner'), ('device', 'Device'), ('care-team', 'Care Team'), ('healthcare-service', 'Healthcare Service'), ('location', 'Location'), ('organization', 'Organization')], max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='uri',
            field=models.URLField(null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='use_context',
            field=models.ManyToManyField(blank=True, related_name='group_use_context', to='base.usagecontext'),
        ),
        migrations.AddField(
            model_name='group',
            name='version',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='group',
            name='version_algorithm_coding',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_version_algorithm_coding', to='base.coding'),
        ),
        migrations.AddField(
            model_name='group',
            name='version_algorithm_string',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.CreateModel(
            name='GroupMemberEntityReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_group', to='groups.group')),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_healthcare_service', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_location', to='locations.location')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('inactive', models.BooleanField(default=False)),
                ('entity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_entity', to='groups.groupmemberentityreference')),
                ('involvement', models.ManyToManyField(blank=True, related_name='group_member_involvement', to='base.codeableconcept')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_member_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupManagingEntityReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupCharacteristicDeterminedByReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_determined_by_reference_device', to='devices.device')),
                ('device_definition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='devicedefinitions.devicedefinition')),
                ('device_metric', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_determined_by_reference_device_metric', to='devicemetrics.devicemetric')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_determined_by_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupCharacteristic',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_uri', models.URLField(null=True)),
                ('exclude', models.BooleanField(null=True)),
                ('description', models.TextField(null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_code', to='base.codeableconcept')),
                ('determined_by_expression', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_determined_by_expression', to='base.expression')),
                ('determined_by_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_determined_by_reference', to='groups.groupcharacteristicdeterminedbyreference')),
                ('duration_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_duration_duration', to='base.quantity')),
                ('duration_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_duration_range', to='base.range')),
                ('instances_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_instances_quantity', to='base.quantity')),
                ('instances_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_instances_range', to='base.range')),
                ('method', models.ManyToManyField(blank=True, related_name='group_characteristic_method', to='base.codeableconcept')),
                ('offset', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_offset', to='base.codeableconcept')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_period', to='base.period')),
                ('timing', models.ManyToManyField(blank=True, related_name='group_characteristic_timing', to='base.relativetime')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_value_code', to='base.codeableconcept')),
                ('value_expression', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_value_expression', to='base.expression')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_value_quantity', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_value_range', to='base.range')),
                ('value_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_characteristic_value_reference', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='group',
            name='characteristic',
            field=models.ManyToManyField(blank=True, related_name='group_characteristic', to='groups.groupcharacteristic'),
        ),
        migrations.AddField(
            model_name='group',
            name='managing_entity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_managing_entity', to='groups.groupmanagingentityreference'),
        ),
        migrations.AddField(
            model_name='group',
            name='member',
            field=models.ManyToManyField(blank=True, related_name='group_member', to='groups.groupmember'),
        ),
    ]
