# Generated by Django 4.2.14 on 2025-02-11 11:50

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('procedures', '0001_initial'),
        ('nutritionintakes', '0004_nutritionintakenutritionitemconsumeditem_total_intake'),
        ('nutritionorders', '0001_initial'),
        ('servicerequests', '0004_alter_servicerequest_intent'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('patients', '0007_patientorganizationreference'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('observations', '0006_alter_observation_instantiates_reference_and_more'),
        ('organizations', '0003_organization_endpoint'),
    ]

    operations = [
        migrations.CreateModel(
            name='GoalTarget',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('detail_string', models.CharField(max_length=255, null=True)),
                ('detail_boolean', models.BooleanField(default=False)),
                ('detail_integer', models.IntegerField(null=True)),
                ('due_date', models.DateField(null=True)),
                ('detail_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_detail_codeable_concept', to='base.codeableconcept')),
                ('detail_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_detail_quantity', to='base.quantity')),
                ('detail_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_detail_range', to='base.range')),
                ('detail_ratio', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_detail_ratio', to='base.ratio')),
                ('due_duration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_due_duration', to='base.duration')),
                ('measure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_target_measure', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoalSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_subject_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_subject_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_subject_reference_patient', to='patients.patient')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoalSourceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_care_team', to='careteams.careteam')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_source_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoalAddressesReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_condition', to='conditions.condition')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('nutrition_intake', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_nutrition_intake', to='nutritionintakes.nutritionintake')),
                ('nutrition_order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_nutrition_order', to='nutritionorders.nutritionorder')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_procedure', to='procedures.procedure')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='goal_addresses_reference_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoalAcceptanceParticipantReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_care_team', to='careteams.careteam')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GoalAcceptance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('agree', 'Agree'), ('disagree', 'Disagree'), ('pending', 'Pending')], max_length=255)),
                ('participant', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_participant', to='goals.goalacceptanceparticipantreference')),
                ('priority', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_acceptance_priority', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Goal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('lifecycle_status', models.CharField(choices=[('proposed', 'Proposed'), ('planned', 'Planned'), ('accepted', 'Accepted'), ('active', 'Active'), ('on-hold', 'On Hold'), ('completed', 'Completed'), ('cancelled', 'Cancelled'), ('entered-in-error', 'Entered in Error'), ('rejected', 'Rejected')], max_length=255)),
                ('continuous', models.BooleanField(default=False)),
                ('start_date', models.DateField(null=True)),
                ('status_date', models.DateField(null=True)),
                ('acceptance', models.ManyToManyField(blank=True, related_name='goal_acceptance', to='goals.goalacceptance')),
                ('achievement_status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_achievement_status', to='base.codeableconcept')),
                ('addresses', models.ManyToManyField(blank=True, related_name='goal_addresses', to='goals.goaladdressesreference')),
                ('category', models.ManyToManyField(blank=True, related_name='goal_category', to='base.codeableconcept')),
                ('description', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_description', to='base.codeableconcept')),
                ('identifier', models.ManyToManyField(blank=True, related_name='goal_identifier', to='base.identifier')),
                ('note', models.ManyToManyField(blank=True, related_name='goal_note', to='base.annotation')),
                ('priority', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_priority', to='base.codeableconcept')),
                ('source', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_source', to='goals.goalsourcereference')),
                ('start_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_start_code', to='base.codeableconcept')),
                ('status_reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_status_code', to='base.codeableconcept')),
                ('subject', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='goal_subject', to='goals.goalsubjectreference')),
                ('target', models.ManyToManyField(blank=True, related_name='goal_target', to='goals.goaltarget')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
