# Generated by Django 4.2.14 on 2025-02-20 10:32

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("specimens", "0002_rename_specimencollections_specimencollection_and_more"),
        ("nutritionproducts", "0003_remove_nutritionproductnutrients_allergen"),
        ("substances", "0002_substancecodeablereference"),
        ("encounters", "0009_encounterepisodeofcarereference"),
        ("base", "0013_money"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("biologicallyderivedproducts", "0001_initial"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
        ("conditions", "0006_merge_20250217_1423"),
        ("patients", "0007_patientorganizationreference"),
        ("observations", "0009_documentreferenceobservationreference"),
        ("organizations", "0003_organization_endpoint"),
        ("procedures", "0008_merge_20250218_1723"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("devices", "0007_alter_device_status_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="GenomicStudy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("registered", "Registered"),
                            ("available", "Available"),
                            ("cancelled", "Cancelled"),
                            ("enter-in-error", "Enter in Error"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=200,
                        null=True,
                    ),
                ),
                ("start_date", models.DateTimeField(null=True)),
                ("instantiates_uri", models.URLField(null=True)),
                ("description", models.TextField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudySubjectReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_derived_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_biologically_derived_product",
                        to="biologicallyderivedproducts.biologicallyderivedproduct",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_group",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "nutrition_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_nutrition_product",
                        to="nutritionproducts.nutritionproduct",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_subject_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "genomic_study",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_reference_genomic_study",
                        to="genomicstudy.genomicstudy",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_based_on_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_based_on_reference_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisProtocolPerformedReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="procedure_task_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="procedure_task_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_actor",
                        to="genomicstudy.genomicstudyanalysisperformeractorreference",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_performer_role",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisOutput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_output_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisInput",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "generated_by_identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_input_generated_by_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "generated_by_reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_input_generated_by_reference",
                        to="genomicstudy.genomicstudyreference",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_input_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysisDevice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_device_device",
                        to="devices.devicereference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_device_function",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="GenomicStudyAnalysis",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("instantiates_uri", models.URLField(null=True)),
                ("title", models.CharField(max_length=200, null=True)),
                ("date", models.DateTimeField(null=True)),
                (
                    "change_type",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_change_type",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "device",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_device",
                        to="genomicstudy.genomicstudyanalysisdevice",
                    ),
                ),
                (
                    "focus",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_focus",
                        to="base.reference",
                    ),
                ),
                (
                    "genomic_build",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_genomic_build",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "input",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_input",
                        to="genomicstudy.genomicstudyanalysisinput",
                    ),
                ),
                (
                    "method_type",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_method_type",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "output",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_output",
                        to="genomicstudy.genomicstudyanalysisoutput",
                    ),
                ),
                (
                    "performer",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_performer",
                        to="genomicstudy.genomicstudyanalysisperformer",
                    ),
                ),
                (
                    "protocol_performed",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="genomic_study_analysis_protocol_performed",
                        to="genomicstudy.genomicstudyanalysisprotocolperformedreference",
                    ),
                ),
                (
                    "regions_called",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_regions_called",
                        to="observations.documentreferenceobservationreference",
                    ),
                ),
                (
                    "regions_studied",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_regions_studied",
                        to="observations.documentreferenceobservationreference",
                    ),
                ),
                (
                    "specimen",
                    models.ManyToManyField(
                        blank=True,
                        related_name="genomic_study_analysis_specimen",
                        to="specimens.specimenreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="analysis",
            field=models.ManyToManyField(
                blank=True,
                related_name="genomic_study_analysis",
                to="genomicstudy.genomicstudyanalysis",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="based_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="genomic_study_based_on",
                to="genomicstudy.genomicstudybasedonreference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="genomic_study_encounter",
                to="encounters.encounterreference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="genomic_study_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="interpreter",
            field=models.ManyToManyField(
                blank=True,
                related_name="genomic_study_interpreter",
                to="practitioners.practitionerpractitionerrolereference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="note",
            field=models.ManyToManyField(
                blank=True, related_name="genomic_study_note", to="base.annotation"
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="genomic_study_reason",
                to="conditions.conditionobservationcodeablereference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="referrer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="genomic_study_referrer",
                to="practitioners.practitionerpractitionerrolereference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="genomic_study_subject",
                to="genomicstudy.genomicstudysubjectreference",
            ),
        ),
        migrations.AddField(
            model_name="genomicstudy",
            name="type",
            field=models.ManyToManyField(
                blank=True, related_name="genomic_study_type", to="base.codeableconcept"
            ),
        ),
    ]
