# Generated by Django 4.2.14 on 2025-02-05 16:11

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('observations', '0006_alter_observation_instantiates_reference_and_more'),
        ('base', '0011_age_duration_simplequantity'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('diagnosticreports', '0004_rename_media_diagnosticreportmedia_and_more'),
        ('patients', '0007_patientorganizationreference'),
        ('devices', '0007_alter_device_status_and_more'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('conditions', '0002_alter_conditioncodeablereference_concept_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='FamilyMemberHistoryReasonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_reference_condition', to='conditions.condition')),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_reference_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_reference_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistoryReasonCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_codeable_reference_codeable_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_reason_codeable_reference_reference', to='familymemberhistories.familymemberhistoryreasonreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistoryProcedure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('contributed_to_death', models.BooleanField(null=True)),
                ('performed_string', models.CharField(max_length=255, null=True)),
                ('performed_date_time', models.DateTimeField(null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_procedure_code', to='base.codeableconcept')),
                ('note', models.ManyToManyField(blank=True, related_name='family_member_history_procedure_note', to='base.annotation')),
                ('outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_procedure_outcome', to='base.codeableconcept')),
                ('performed_age', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_procedure_performed_age', to='base.age')),
                ('performed_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_procedure_performed_period', to='base.period')),
                ('performed_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_procedure_performed_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistoryParticipantActorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_organization', to='base.organizationreference')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistoryParticipant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('actor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_actor', to='familymemberhistories.familymemberhistoryparticipantactorreference')),
                ('function', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_participant_function', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistoryCondition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('contributed_to_death', models.BooleanField(null=True)),
                ('onset_string', models.CharField(max_length=255, null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_condition_code', to='base.codeableconcept')),
                ('note', models.ManyToManyField(blank=True, related_name='family_member_history_condition_note', to='base.annotation')),
                ('onset_age', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_condition_onset_age', to='base.age')),
                ('onset_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_condition_onset_period', to='base.period')),
                ('onset_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_condition_onset_range', to='base.range')),
                ('outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_condition_outcome', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FamilyMemberHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('partial', 'Partial'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('health-unknown', 'Health Unknown')], max_length=255)),
                ('date', models.DateTimeField(null=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('born_date', models.DateTimeField(null=True)),
                ('born_string', models.CharField(max_length=255, null=True)),
                ('age_string', models.CharField(max_length=255, null=True)),
                ('estimated_age', models.BooleanField(null=True)),
                ('deceased_boolean', models.BooleanField(null=True)),
                ('deceased_date', models.DateTimeField(null=True)),
                ('deceased_string', models.CharField(max_length=255, null=True)),
                ('age_age', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_age_age', to='base.age')),
                ('age_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_age_range', to='base.range')),
                ('born_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_born_period', to='base.period')),
                ('condition', models.ManyToManyField(blank=True, related_name='family_member_history_condition', to='familymemberhistories.familymemberhistorycondition')),
                ('data_absent_reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='family_member_history_data_absent_reason', to='base.codeableconcept')),
                ('deceased_age', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_deceased_age', to='base.age')),
                ('deceased_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_deceased_range', to='base.range')),
                ('identifier', models.ManyToManyField(blank=True, related_name='family_member_history_identifier', to='base.identifier')),
                ('note', models.ManyToManyField(blank=True, related_name='family_member_history_note', to='base.annotation')),
                ('participant', models.ManyToManyField(blank=True, related_name='family_member_history_participant', to='familymemberhistories.familymemberhistoryparticipant')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_patient', to='patients.patientreference')),
                ('procedure', models.ManyToManyField(blank=True, related_name='family_member_history_procedure', to='familymemberhistories.familymemberhistoryprocedure')),
                ('reason', models.ManyToManyField(blank=True, related_name='family_member_history_reason', to='familymemberhistories.familymemberhistoryreasoncodeablereference')),
                ('relationship', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_relationship', to='base.codeableconcept')),
                ('sex', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='family_member_history_sex', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
