# Generated by Django 4.2.14 on 2025-03-12 11:56

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('claims', '0003_remove_claim_sub_type_claim_sub_type'),
        ('procedures', '0008_merge_20250218_1723'),
        ('coverages', '0005_coveragereference'),
        ('nutritionorders', '0005_rename_instantiated_nutritionorder_instantiates_and_more'),
        ('visionprescriptions', '0001_initial'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('devices', '0007_alter_device_status_and_more'),
        ('patients', '0007_patientorganizationreference'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('bodystructures', '0006_bodystructurecodeablereference'),
        ('locations', '0006_merge_20250129_1542'),
        ('organizations', '0004_organizationcodeablereference'),
        ('conditions', '0006_merge_20250217_1423'),
        ('base', '0018_merge_20250307_1944'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('practitioners', '0011_practitionerrolereference'),
        ('servicerequests', '0005_servicerequestplandefinitionreference_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExplanationOfBenefitItemAdjudication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_adjudication_amount', to='base.money')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_adjudication_category', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_adjudication_quantity', to='base.quantity')),
                ('reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_adjudication_reason', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitTotal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_total_amount', to='base.money')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_total_category', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitSupportingInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('timing_date', models.DateField(null=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_category', to='base.codeableconcept')),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_code', to='base.codeableconcept')),
                ('reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_reason', to='base.coding')),
                ('timing_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_timing_period', to='base.period')),
                ('value_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_value_attachment', to='base.attachment')),
                ('value_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_value_identifier', to='base.identifier')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_value_quantity', to='base.quantity')),
                ('value_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_supporting_info_value_reference', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitRelated',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('claim', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_related_claim', to='claims.claimreference')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_related_reference', to='base.identifier')),
                ('relationship', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_related_relationship', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitProviderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_provider_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_provider_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_provider_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_provider_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitProcessNote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('number', models.PositiveIntegerField()),
                ('text', models.TextField()),
                ('language', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_process_note_language', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_process_note_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitProcedure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('date', models.DateTimeField()),
                ('procedure_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_procedure_procedure_codeable_concept', to='base.codeableconcept')),
                ('procedure_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_procedure_procedure_reference', to='procedures.procedurereference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_procedure_type', to='base.codeableconcept')),
                ('udi', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_procedure_udi', to='devices.devicereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitPrescriptionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_prescription_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_prescription_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('vision_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_prescription_reference_vision_prescription', to='visionprescriptions.visionprescription')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateField()),
                ('adjustment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payment_adjustment', to='base.money')),
                ('adjustment_reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payment_adjustment_reason', to='base.codeableconcept')),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payment_amount', to='base.money')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payment_identifier', to='base.identifier')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payment_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitPayeePartyReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitPayee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('party', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_party', to='explanationofbenefits.explanationofbenefitpayeepartyreference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_payee_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItemReviewOutcome',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('pre_auth_ref', models.CharField(max_length=255)),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_review_outcome_decision', to='base.codeableconcept')),
                ('pre_auth_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_review_outcome_pre_auth_period', to='base.period')),
                ('reason', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_review_outcome_reason', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItemRequestReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_request_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_request_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('nutrition_order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_request_reference_nutrition_order', to='nutritionorders.nutritionorder')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_request_reference_service_request', to='servicerequests.servicerequest')),
                ('vision_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_request_reference_vision_prescription', to='visionprescriptions.visionprescription')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItemDetailSubDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_category', to='base.codeableconcept')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_revenue', to='base.codeableconcept')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_review_outcome', to='explanationofbenefits.explanationofbenefititemreviewoutcome')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_sub_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItemDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_category', to='base.codeableconcept')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_revenue', to='base.codeableconcept')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_review_outcome', to='explanationofbenefits.explanationofbenefititemreviewoutcome')),
                ('sub_detail', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_sub_detail', to='explanationofbenefits.explanationofbenefititemdetailsubdetail')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItemBodySite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('site', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_body_site_site', to='bodystructures.bodystructurecodeablereference')),
                ('sub_site', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_body_site_sub_site', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('care_team_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('diagnosis_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('procedure_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('information_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('serviced_date', models.DateField(null=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('body_site', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_body_site', to='explanationofbenefits.explanationofbenefititembodysite')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_category', to='base.codeableconcept')),
                ('detail', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_detail', to='explanationofbenefits.explanationofbenefititemdetail')),
                ('encounter', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_encounter', to='encounters.encounterreference')),
                ('location_address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_location_address', to='base.address')),
                ('location_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_location_codeable_concept', to='base.codeableconcept')),
                ('location_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_location_reference', to='locations.locationreference')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_quantity', to='base.simplequantity')),
                ('request', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_request', to='explanationofbenefits.explanationofbenefititemrequestreference')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_revenue', to='base.codeableconcept')),
                ('serviced_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_serviced_period', to='base.period')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_item_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_item_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitInsurance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('focal', models.BooleanField(default=False)),
                ('pre_auth_ref', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('coverage', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_insurance_coverage', to='coverages.coveragereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('when_date_time', models.DateTimeField(null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_event_code', to='base.codeableconcept')),
                ('when_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_event_when_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitEntererReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_enterer_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_enterer_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_enterer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_enterer_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_enterer_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitDiagnosis',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('diagnosis_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_diagnosis_diagnosis_codeable_concept', to='base.codeableconcept')),
                ('diagnosis_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_diagnosis_diagnosis_reference', to='conditions.conditionreference')),
                ('on_admission', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_diagnosis_on_admission', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_diagnosis_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitCareTeam',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.PositiveIntegerField()),
                ('responsible', models.BooleanField(default=False)),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_care_team_provider', to='explanationofbenefits.explanationofbenefitproviderreference')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_care_team_role', to='base.codeableconcept')),
                ('specialty', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_care_team_qualification', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitBenefitBalanceFinancial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('allowed_money_unsigned_int', models.PositiveIntegerField(null=True)),
                ('allowed_string', models.CharField(max_length=255, null=True)),
                ('used_money_unsigned_int', models.PositiveIntegerField(null=True)),
                ('allowed_money', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_financial_allowed_money', to='base.money')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_financial_type', to='base.codeableconcept')),
                ('used_money', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_financial_used_money', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitBenefitBalance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('description', models.TextField()),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_category', to='base.codeableconcept')),
                ('financial', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_benefit_balance_financial', to='explanationofbenefits.explanationofbenefitbenefitbalancefinancial')),
                ('network', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_network', to='base.codeableconcept')),
                ('term', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_term', to='base.codeableconcept')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_benefit_balance_unit', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitAddItemDetailSubDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_sub_detail_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_sub_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_product_or_service_end', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_revenue', to='base.codeableconcept')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_review_outcome', to='explanationofbenefits.explanationofbenefititemreviewoutcome')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_sub_detail_trace_number', to='base.identifier')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_sub_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitAddItemDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_product_or_service_end', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_revenue', to='base.codeableconcept')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_review_outcome', to='explanationofbenefits.explanationofbenefititemreviewoutcome')),
                ('sub_detail', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_sub_detail', to='explanationofbenefits.explanationofbenefitadditemdetailsubdetail')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail_trace_number', to='base.identifier')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitAddItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('item_sequence', models.PositiveIntegerField()),
                ('detail_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('sub_detail_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('serviced_date', models.DateField(null=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.PositiveIntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('body_site', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_body_site', to='explanationofbenefits.explanationofbenefititembodysite')),
                ('detail', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_detail', to='explanationofbenefits.explanationofbenefitadditemdetail')),
                ('location_address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_location_address', to='base.address')),
                ('location_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_location_codeable_concept', to='base.codeableconcept')),
                ('location_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_location_reference', to='locations.locationreference')),
                ('modifier', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_program_code', to='base.codeableconcept')),
                ('provider', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_provider', to='explanationofbenefits.explanationofbenefitproviderreference')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_quantity', to='base.simplequantity')),
                ('request', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_request', to='explanationofbenefits.explanationofbenefititemrequestreference')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_review_outcome', to='explanationofbenefits.explanationofbenefititemreviewoutcome')),
                ('serviced_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_serviced_period', to='base.period')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='explanation_of_benefit_add_item_trace_number', to='base.identifier')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_add_item_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefitAccident',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateField(null=True)),
                ('location_address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_accident_location_address', to='base.address')),
                ('location_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_accident_location_location', to='locations.locationreference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefit_accident_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExplanationOfBenefit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], default='active', max_length=255)),
                ('use', models.CharField(choices=[('claim', 'Claim'), ('preauthorization', 'Preauthorization'), ('predetermination', 'Predetermination')], default='claim', max_length=255)),
                ('created', models.DateTimeField()),
                ('outcome', models.CharField(choices=[('queued', 'Queued'), ('complete', 'Complete'), ('error', 'Error'), ('partial', 'Partial')], default='complete', max_length=255)),
                ('disposition', models.TextField(null=True)),
                ('pre_auth_ref', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('precedence', models.PositiveIntegerField(null=True)),
                ('accident', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_accident', to='explanationofbenefits.explanationofbenefitaccident')),
                ('add_item', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_add_item', to='explanationofbenefits.explanationofbenefitadditem')),
                ('adjudication', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_adjudication', to='explanationofbenefits.explanationofbenefititemadjudication')),
                ('benefit_balance', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_benefit_balance', to='explanationofbenefits.explanationofbenefitbenefitbalance')),
                ('benefit_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_benefit_period', to='base.period')),
                ('billable_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_billable_period', to='base.period')),
                ('care_team', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_care_team', to='explanationofbenefits.explanationofbenefitcareteam')),
                ('claim', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_claim', to='claims.claimreference')),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_decision', to='base.codeableconcept')),
                ('diagnosis', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_diagnosis', to='explanationofbenefits.explanationofbenefitdiagnosis')),
                ('diagnosis_related_group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_diagnosis_related_group', to='base.codeableconcept')),
                ('encounter', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_encounter', to='encounters.encounterreference')),
                ('enterer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_enterer', to='explanationofbenefits.explanationofbenefitentererreference')),
                ('event', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_event', to='explanationofbenefits.explanationofbenefitevent')),
                ('facility', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_facility', to='locations.locationorganizationreference')),
                ('form', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_form', to='base.attachment')),
                ('form_code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_form_code', to='base.codeableconcept')),
                ('funds_reserve', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_funds_reserve', to='base.codeableconcept')),
                ('funds_reserve_requested', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_funds_reserve_requested', to='base.codeableconcept')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_identifier', to='base.identifier')),
                ('insurance', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_insurance', to='explanationofbenefits.explanationofbenefitinsurance')),
                ('insurer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_insurer', to='base.organizationreference')),
                ('item', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_item', to='explanationofbenefits.explanationofbenefititem')),
                ('original_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_original_prescription', to='medicationrequests.medicationrequestreference')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_patient', to='patients.patientreference')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_patient_paid', to='base.money')),
                ('payee', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_payee', to='explanationofbenefits.explanationofbenefitpayee')),
                ('payment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_payment', to='explanationofbenefits.explanationofbenefitpayment')),
                ('pre_auth_period', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_pre_auth_period', to='base.period')),
                ('prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_prescription', to='explanationofbenefits.explanationofbenefitprescriptionreference')),
                ('priority', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_priority', to='base.codeableconcept')),
                ('procedure', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_procedure', to='explanationofbenefits.explanationofbenefitprocedure')),
                ('process_note', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_process_note', to='explanationofbenefits.explanationofbenefitprocessnote')),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_provider', to='explanationofbenefits.explanationofbenefitproviderreference')),
                ('referral', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_referral', to='servicerequests.servicerequestreference')),
                ('related', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_funds_related', to='explanationofbenefits.explanationofbenefitrelated')),
                ('sub_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_sub_type', to='base.codeableconcept')),
                ('supporting_info', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_supporting_info', to='explanationofbenefits.explanationofbenefitsupportinginfo')),
                ('total', models.ManyToManyField(blank=True, related_name='explanation_of_benefits_total', to='explanationofbenefits.explanationofbenefittotal')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='explanation_of_benefits_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
