# Generated by Django 4.2.14 on 2025-01-10 10:41

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('practitioners', '0007_remove_practitionerrole_availability_and_more'),
        ('servicerequests', '0001_initial'),
        ('medicationrequests', '0002_initial'),
        ('patients', '0004_patientgroupreference'),
        ('base', '0003_communication'),
        ('locations', '0001_initial'),
        ('observations', '0002_initial'),
        ('healthcareservices', '0005_remove_healthcareservicecodeablereference_healthcare_service'),
        ('diagnosticreports', '0002_initial'),
        ('encounters', '0002_initial'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='encounter',
            name='accounts',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='admit_source',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='appointment',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='based_on',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='care_team',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='destination',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='diagnosis',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='diet_preference',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='discharge_disposition',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='encounter_class',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='end_date_time',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='episode_of_care',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='length',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='origin',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='part_of',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='patient',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='re_admission',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='reason',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='service_type',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='special_arrangement',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='special_courtesy',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='start_date_time',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='type',
        ),
        migrations.RemoveField(
            model_name='encounter',
            name='virtual_service',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='encounter',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='end_date_time',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='practitioner',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='required',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='start_date_time',
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='status',
        ),
        migrations.AddField(
            model_name='encounter',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='encounter_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='encounter',
            name='klass',
            field=models.ManyToManyField(blank=True, related_name='encounter_class', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='encounter',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_patient', to='patients.patientgroupreference'),
        ),
        migrations.AddField(
            model_name='encounterparticipant',
            name='period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_period', to='base.period'),
        ),
        migrations.AlterField(
            model_name='encounter',
            name='priority',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_priority', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='encounter',
            name='service_provider',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_service_provider', to='base.organizationreference'),
        ),
        migrations.AlterField(
            model_name='encounter',
            name='subject_status',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_subject_status', to='base.codeableconcept'),
        ),
        migrations.RemoveField(
            model_name='encounterparticipant',
            name='type',
        ),
        migrations.CreateModel(
            name='EncounterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='encounter_reference_encounter', to='encounters.encounter')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='encounter_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterReasonValueReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_reason_value_reference_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_reason_value_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_reason_value_reference_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterReasonValueCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_reason_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_reason_codeable_reference_reference', to='encounters.encounterreasonvaluereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterReason',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('use', models.ManyToManyField(blank=True, related_name='encounter_reason_use', to='base.codeableconcept')),
                ('value', models.ManyToManyField(blank=True, related_name='encounter_reason_value', to='encounters.encounterreasonvaluecodeablereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterParticipantActor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('healthcareservice', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_actor_healthcareservice', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_actor_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_actor_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_actor_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant_actor_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterLocation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('planned', 'Planned'), ('arrived', 'Arrived'), ('triaged', 'Triaged'), ('in_progress', 'In Progress'), ('on_leave', 'On Leave'), ('finished', 'Finished'), ('cancelled', 'Cancelled'), ('entered_in_error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('form', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_location_form', to='base.codeableconcept')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_location_location', to='locations.locationreference')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_location_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterDiagnosis',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('use', models.ManyToManyField(blank=True, related_name='encounter_diagnosis_use', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterBasedOnReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_based_on_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_based_on_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_based_on_reference_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterAdmission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('admit_source', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_admission_admit_source', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
