# Generated by Django 4.2.14 on 2025-01-06 22:48

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DietPreference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Encounter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('planned', 'Planned'), ('arrived', 'Arrived'), ('triaged', 'Triaged'), ('in_progress', 'In Progress'), ('on_leave', 'On Leave'), ('finished', 'Finished'), ('cancelled', 'Cancelled'), ('entered_in_error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('encounter_class', models.CharField(choices=[('inpatient_encounter', 'Inpatient Encounter'), ('outpatient_encounter', 'Outpatient Encounter'), ('observation_encounter', 'Observation Encounter'), ('emergency', 'Emergency'), ('virtual', 'Virtual'), ('home_health', 'Home Health')], max_length=255, null=True)),
                ('priority', models.CharField(choices=[('asap', 'ASAP'), ('callback_results', 'Callback Results'), ('elective', 'Elective'), ('emergency', 'Emergency'), ('preop', 'Preop'), ('as_needed', 'As Needed'), ('routine', 'Routine'), ('rush_reporting', 'Rush Reporting'), ('stat', 'Stat'), ('timing_critical', 'Timing Critical'), ('use_as_directed', 'Use As Directed'), ('urgent', 'Urgent'), ('callback_for_scheduling', 'Callback for Scheduling'), ('callback_placer_for_scheduling', 'Callback Placer for Scheduling'), ('contact_patient_for_scheduling', 'Contact Patient for Scheduling')], max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('subject_status', models.CharField(choices=[('arrived', 'Arrived'), ('triaged', 'Triaged'), ('receiving_care', 'Receiving Care'), ('departed', 'Departed'), ('on_leave', 'On Leave')], max_length=255, null=True)),
                ('start_date_time', models.DateTimeField(null=True)),
                ('end_date_time', models.DateTimeField(null=True)),
                ('planned_start_date', models.DateTimeField(null=True)),
                ('planned_end_date', models.DateTimeField(null=True)),
                ('length', models.DurationField(blank=True, null=True)),
                ('admit_source', models.CharField(choices=[('transfered', 'Transfered'), ('outpatient_department', 'Outpatient Department'), ('emergency_department', 'Emergency or Accident Department'), ('gp_referal', 'Genral Practitioner Referal'), ('mp_referal', 'Medical Practitioner Referal'), ('rehabilitation', 'Rehabilitation Department'), ('psychiatry', 'Psychiatric Department'), ('born_in_hospital', 'Born in Hospital'), ('nursing_home', 'From Nursing Home'), ('other', 'Other')], max_length=255, null=True)),
                ('re_admission', models.BooleanField(default=False)),
                ('discharge_disposition', models.CharField(choices=[('home', 'Home'), ('other_health_care_facility', 'Other Health Care Facility'), ('hospice', 'Hospice'), ('long_term_care', 'Long Term Care'), ('left_against_advice', 'Left Against Advice'), ('expired', 'Expired'), ('psychiatric_hospital', 'Psychiatric Hospital'), ('rehabilitation', 'Rehabilitation'), ('skilled_nursing', 'Skilled Nursing'), ('alternative_home', 'Alternative Home'), ('other', 'Other')], max_length=255, null=True)),
                ('episode_of_care', models.CharField(max_length=255, null=True)),
                ('based_on', models.CharField(max_length=255, null=True)),
                ('care_team', models.CharField(max_length=255, null=True)),
                ('accounts', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterCondition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpecialArrangement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpecialCourtesy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterParticipant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('admitter', 'Admitter'), ('attender', 'Attender'), ('callback_contact', 'Callback Contact'), ('consultant', 'Consultant'), ('discharger', 'Discharger'), ('emergency_contact', 'Emergency Contact'), ('escort', 'Escort'), ('referrer', 'Referrer'), ('translator', 'Translator')], max_length=255, null=True)),
                ('required', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('accepted', 'Accepted'), ('declined', 'Declined'), ('tentative', 'Tentative'), ('needs_action', 'Needs Action')], max_length=255, null=True)),
                ('start_date_time', models.DateTimeField(null=True)),
                ('end_date_time', models.DateTimeField(null=True)),
                ('encounter', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='encounter_participant', to='encounters.encounter')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
