# Generated by Django 4.2.14 on 2025-02-11 15:35

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("organizations", "0003_organization_endpoint")
    ]

    operations = [
        migrations.CreateModel(
            name="DocumentReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("version", models.CharField(max_length=255, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("current", "Current"),
                            ("suppressed", "Suppressed"),
                            ("entered-in-error", "Entered in error"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "doc_status",
                    models.CharField(
                        choices=[
                            ("registered", "Registered"),
                            ("partial", "Partial"),
                            ("preliminary", "Preliminary"),
                            ("final", "Final"),
                            ("amended", "Amended"),
                            ("corrected", "Corrected"),
                            ("appended", "Appended"),
                            ("cancelled", "Cancelled"),
                            ("entered-in-error", "Entered in error"),
                            ("deprecated", "Deprecated"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("date", models.DateTimeField(null=True)),
                ("description", models.TextField(null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "document_reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_references_document_reference",
                        to="documentreferences.documentreference",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_references_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceRelatesTo",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_relates_tos_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "target",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_relates_tos_target",
                        to="documentreferences.documentreferencereference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceContentProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("value_uri", models.URLField(null=True)),
                (
                    "value_coding",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_content_profiles_value_coding",
                        to="base.coding",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceContent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "attachment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_contents_attachment",
                        to="base.attachment",
                    ),
                ),
                (
                    "profile",
                    models.ManyToManyField(
                        blank=True,
                        related_name="document_reference_contents_profile",
                        to="documentreferences.documentreferencecontentprofile",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceCodeableReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_codeable_references_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_codeable_references_reference",
                        to="base.reference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "appointment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_based_on_reference_appointment",
                        to="appointments.appointment",
                    ),
                ),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_based_on_reference_care_plan",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_based_on_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_based_on_reference_medication_request",
                        to="medicationrequests.medicationrequest",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_based_on_reference_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceAuthorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_author_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceAttesterPartyReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_reference_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_references_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attester_party_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DocumentReferenceAttester",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("time", models.DateTimeField(null=True)),
                (
                    "mode",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attesters_mode",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "party",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="document_reference_attesters_party",
                        to="documentreferences.documentreferenceattesterpartyreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="documentreference",
            name="attester",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_attesters",
                to="documentreferences.documentreferenceattester",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="author",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_authors",
                to="documentreferences.documentreferenceauthorreference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="base_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_based_on",
                to="documentreferences.documentreferencebasedonreference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="category",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_categories",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="content",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_contents",
                to="documentreferences.documentreferencecontent",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="context",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_contexts",
                to="appointments.appointmentreference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="custodian",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_custodian",
                to="base.organizationreference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="event",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_events",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="facility_type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_facility_type",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="modality",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_modalities",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_source_patient_infos",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="practice_setting",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_practice_setting",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="related",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_related",
                to="base.reference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="relates_to",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_relates_tos",
                to="documentreferences.documentreferencerelatesto",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="security_label",
            field=models.ManyToManyField(
                blank=True,
                related_name="document_reference_security_labels",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_subject",
                to="base.reference",
            ),
        ),
        migrations.AddField(
            model_name="documentreference",
            name="type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="document_reference_type",
                to="base.codeableconcept",
            ),
        ),
    ]
