# Generated by Django 4.2.14 on 2025-01-12 15:35

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('encounters', '0008_alter_encounterlocation_location'),
        ('medications', '0003_remove_ratio_denominator_remove_ratio_numerator_and_more'),
        ('observations', '0002_initial'),
        ('base', '0005_codeablereference'),
        ('patients', '0004_patientgroupreference'),
        ('medicationrequests', '0002_initial'),
        ('locations', '0003_alter_locationorganizationreference_location_and_more'),
        ('practitioners', '0007_remove_practitionerrole_availability_and_more'),
        ('healthcareservices', '0005_remove_healthcareservicecodeablereference_healthcare_service'),
        ('organizations', '0001_initial'),
        ('servicerequests', '0001_initial'),
        ('diagnosticreports', '0002_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommunicationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('communication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='communication_reference_communication', to='base.communication')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='communication_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ConclusionCodeCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='conclusion_code_codeable_reference_concept', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ConclusionCodeReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='conclusion_code_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='conclusion_code_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DiagnosticReportBasedOnReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_based_on_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_based_on_medication_request', to='medicationrequests.medicationrequest')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_based_on_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DiagnosticReportEffective',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('effective_date_time', models.DateTimeField(null=True)),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DiagnosticReportPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='performer_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='performer_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='performer_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='performer_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DiagnosticReportSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_subject_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='locations.location')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_subject_medication', to='medications.medication')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_subject_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='practitioners.practitioner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EncounterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='encounters.encounter')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ObservationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='observation_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='observation_reference', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SupportingInfoReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='diagnosticresultinterpretation',
            name='diagnostic_report',
        ),
        migrations.RemoveField(
            model_name='diagnosticresultinterpretation',
            name='practitioner',
        ),
        migrations.RenameField(
            model_name='diagnosticreport',
            old_name='effective_end_datetime',
            new_name='effective_date_time',
        ),
        migrations.RenameField(
            model_name='diagnosticreport',
            old_name='effective_start_datetime',
            new_name='issued',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='attachment',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='issued_date_time',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='patient',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='specimen',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='study',
        ),
        migrations.RemoveField(
            model_name='media',
            name='diagnostic_report',
        ),
        migrations.RemoveField(
            model_name='media',
            name='link',
        ),
        migrations.RemoveField(
            model_name='supportinginfo',
            name='diagnostic_report',
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='effective_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_report_effective_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='media',
            field=models.ManyToManyField(blank=True, to='diagnosticreports.media'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='presented_form',
            field=models.ManyToManyField(blank=True, to='base.attachment'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_supporting_info', to='diagnosticreports.supportinginfo'),
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='based_on',
        ),
        migrations.AlterField(
            model_name='diagnosticreport',
            name='category',
            field=models.ManyToManyField(blank=True, related_name='diagnostics_report_category', to='base.codeableconcept'),
        ),
        migrations.AlterField(
            model_name='diagnosticreport',
            name='code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostics_report_code', to='base.codeableconcept'),
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='communication',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='note',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='recommendation',
        ),
        migrations.RemoveField(
            model_name='diagnosticreport',
            name='result',
        ),
        migrations.AlterField(
            model_name='supportinginfo',
            name='type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='supporting_info_type', to='base.codeableconcept'),
        ),
        migrations.DeleteModel(
            name='DiagnosticReportPerformer',
        ),
        migrations.DeleteModel(
            name='DiagnosticResultInterpretation',
        ),
        migrations.AddField(
            model_name='supportinginforeference',
            name='diagnostic_report',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='supporting_info_diagnostic_report', to='diagnosticreports.diagnosticreport'),
        ),
        migrations.AddField(
            model_name='supportinginforeference',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='supporting_info_reference_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='supportinginforeference',
            name='observation',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='supporting_info_observation', to='observations.observation'),
        ),
        migrations.AddField(
            model_name='conclusioncodecodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='conclusion_code_codeable_reference_codeable', to='diagnosticreports.conclusioncodereference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='performer',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_performer', to='diagnosticreports.diagnosticreportperformerreference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='results_interpretation',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_results_interpretation', to='diagnosticreports.diagnosticreportperformerreference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='diagnosticreports.diagnosticreportsubjectreference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='based_on',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_based_on', to='diagnosticreports.diagnosticreportbasedonreference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='communication',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_communication', to='diagnosticreports.communicationreference'),
        ),
        migrations.AlterField(
            model_name='diagnosticreport',
            name='conclusion_code',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_conclusion_code', to='diagnosticreports.conclusioncodecodeablereference'),
        ),
        migrations.AlterField(
            model_name='diagnosticreport',
            name='encounter',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='diagnostic_encounter', to='diagnosticreports.encounterreference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_report_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='recommendation',
            field=models.ManyToManyField(blank=True, to='base.codeablereference'),
        ),
        migrations.AddField(
            model_name='diagnosticreport',
            name='result',
            field=models.ManyToManyField(blank=True, related_name='diagnostic_result', to='diagnosticreports.observationreference'),
        ),
        migrations.AlterField(
            model_name='supportinginfo',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='supporting_info_reference', to='diagnosticreports.supportinginforeference'),
        ),
    ]
