# Generated by Django 4.2.14 on 2025-03-13 11:40

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('diagnosticreports', '0005_diagnosticreportdocumentreferencereference'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('base', '0018_merge_20250307_1944'),
        ('devices', '0008_devicedevicedefinitionreference_and_more'),
        ('organizations', '0004_organizationcodeablereference'),
        ('bodystructures', '0006_bodystructurecodeablereference'),
        ('claims', '0003_remove_claim_sub_type_claim_sub_type'),
        ('practitioners', '0011_practitionerrolereference'),
        ('conditions', '0006_merge_20250217_1423'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('procedures', '0008_merge_20250218_1723'),
        ('patients', '0007_patientorganizationreference'),
        ('servicerequests', '0005_servicerequestplandefinitionreference_and_more'),
        ('documentreferences', '0003_rename_base_on_documentreference_based_on_and_more'),
        ('observations', '0009_documentreferenceobservationreference'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeviceUsageReasonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_condition', to='conditions.condition')),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('document_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_document_reference', to='documentreferences.documentreference')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_reason_reference_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUsageReasonCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_usage_reason_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_usage_reason_codeable_reference_reference', to='deviceusages.deviceusagereasonreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUsageInformationSourceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_usage_information_source_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUsageDerivedFromReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('claim', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_claim', to='claims.claim')),
                ('document_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_document_reference', to='documentreferences.documentreference')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_procedure', to='procedures.procedure')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_derived_from_reference_service_request', to='servicerequests.servicerequest')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUsageAdherence',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_adherence_code', to='base.codeableconcept')),
                ('reason', models.ManyToManyField(blank=True, related_name='device_usage_adherence_reason', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUsage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('completed', 'Completed'), ('not-done', 'Not Done'), ('entered-in-error', 'Entered in Error'), ('intended', 'Intended'), ('stopped', 'Stopped'), ('on-hold', 'On Hold')], default='active', max_length=255)),
                ('timing_date_time', models.DateTimeField(null=True)),
                ('date_asserted', models.DateTimeField(null=True)),
                ('adherence', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_adherence', to='deviceusages.deviceusageadherence')),
                ('based_on', models.ManyToManyField(blank=True, related_name='device_usage_based_on', to='servicerequests.servicerequestreference')),
                ('body_site', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_body_site', to='bodystructures.bodystructurecodeablereference')),
                ('category', models.ManyToManyField(blank=True, related_name='device_usage_category', to='base.codeableconcept')),
                ('context', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_context', to='encounters.encounterepisodeofcarereference')),
                ('derived_from', models.ManyToManyField(blank=True, related_name='device_usage_derived_from', to='deviceusages.deviceusagederivedfromreference')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_device', to='devices.devicedevicedefinitioncodeablereference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='device_usages_identifier', to='base.identifier')),
                ('information_source', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_information_source', to='deviceusages.deviceusageinformationsourcereference')),
                ('note', models.ManyToManyField(blank=True, related_name='device_usage_note', to='base.annotation')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_patient', to='patients.patientreference')),
                ('reason', models.ManyToManyField(blank=True, related_name='device_usage_reason', to='deviceusages.deviceusagereasoncodeablereference')),
                ('timing_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_timing_period', to='base.period')),
                ('timing_timing', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_timing_timing', to='base.timing')),
                ('usage_reason', models.ManyToManyField(blank=True, related_name='device_usage_usage_reason', to='base.codeableconcept')),
                ('usage_status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_usage_usage_status', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
