# Generated by Django 4.2.14 on 2025-01-28 11:41

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0009_remove_endpointreference_endpoint_and_more'),
        ('locations', '0004_remove_location_endpoint'),
        ('devicedefinitions', '0002_devicedefinitiondeviceversion_and_more'),
        ('devices', '0004_alter_devicedevicemetricreference_device_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='device',
            name='availability_status',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_availability_status', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='device',
            name='biological_source_event',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_biological_source_event', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='device',
            name='category',
            field=models.ManyToManyField(blank=True, related_name='devices_category', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='device',
            name='contact',
            field=models.ManyToManyField(blank=True, related_name='devices_contact', to='base.contactpoint'),
        ),
        migrations.AddField(
            model_name='device',
            name='cycle',
            field=models.IntegerField(null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='definition',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='devicedefinitions.devicedefinitionreference'),
        ),
        migrations.AddField(
            model_name='device',
            name='duration',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_duration', to='base.quantity'),
        ),
        migrations.AddField(
            model_name='device',
            name='expiration_date',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='gateway',
            field=models.ManyToManyField(blank=True, related_name='devices_gateway', to='devices.devicecodeablereference'),
        ),
        migrations.AddField(
            model_name='device',
            name='location',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_location', to='locations.locationreference'),
        ),
        migrations.AddField(
            model_name='device',
            name='lot_number',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='manufacture_date',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='manufacturer',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='mode',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_mode', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='device',
            name='model_number',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='devices_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='device',
            name='owner',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_owner', to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='device',
            name='parent',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='devices_parent', to='devices.devicereference'),
        ),
        migrations.AddField(
            model_name='device',
            name='part_number',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='safety',
            field=models.ManyToManyField(blank=True, related_name='devices_safety', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='device',
            name='serial_number',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='device',
            name='type',
            field=models.ManyToManyField(blank=True, related_name='devices_type', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='device',
            name='url',
            field=models.URLField(null=True),
        ),
        migrations.CreateModel(
            name='DeviceVersion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=255, null=True)),
                ('install_date', models.DateTimeField(null=True)),
                ('component', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_version_component', to='base.identifier')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_version_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceUdiCarrier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('device_identifier_system', models.CharField(max_length=255, null=True)),
                ('carrier_hrft', models.CharField(max_length=255, null=True)),
                ('carrier_aidc', models.CharField(max_length=255, null=True)),
                ('issuer', models.CharField(max_length=255, null=True)),
                ('jurisdiction', models.CharField(max_length=255, null=True)),
                ('carrier', models.CharField(max_length=255, null=True)),
                ('entry_type', models.CharField(max_length=255, null=True)),
                ('device_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_udi_carrier_device_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceProperty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_integer', models.IntegerField(null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_property_type', to='base.codeableconcept')),
                ('value_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_property_value_attachment', to='base.attachment')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_property_value_code', to='base.codeableconcept')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_property_value_quantity', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_property_value_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=255, null=True)),
                ('display', models.BooleanField(default=False, null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_name_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceConformsTo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_conforms_to_category', to='base.codeableconcept')),
                ('specification', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_conforms_to_specification', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='device',
            name='conforms_to',
            field=models.ManyToManyField(blank=True, related_name='devices_conforms_to', to='devices.deviceconformsto'),
        ),
        migrations.AddField(
            model_name='device',
            name='device_version',
            field=models.ManyToManyField(blank=True, related_name='devices_device_version', to='devices.deviceversion'),
        ),
        migrations.AddField(
            model_name='device',
            name='name',
            field=models.ManyToManyField(blank=True, related_name='devices_name', to='devices.devicename'),
        ),
        migrations.AddField(
            model_name='device',
            name='property',
            field=models.ManyToManyField(blank=True, related_name='devices_property', to='devices.deviceproperty'),
        ),
        migrations.AddField(
            model_name='device',
            name='udi_carrier',
            field=models.ManyToManyField(blank=True, to='devices.deviceudicarrier'),
        ),
    ]
