# Generated by Django 4.2.14 on 2025-03-14 11:46

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('locations', '0006_merge_20250129_1542'),
        ('healthcareservices', '0006_remove_healthcareservice_endpoint'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('documentreferences', '0003_rename_base_on_documentreference_based_on_and_more'),
        ('devices', '0007_alter_device_status_and_more'),
        ('provenances', '0001_initial'),
        ('practitioners', '0011_practitionerrolereference'),
        ('patients', '0007_patientorganizationreference'),
        ('base', '0018_merge_20250307_1944'),
        ('diagnosticreports', '0005_diagnosticreportdocumentreferencereference'),
        ('organizations', '0004_organizationcodeablereference'),
        ('observations', '0009_documentreferenceobservationreference'),
        ('conditions', '0006_merge_20250217_1423'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeviceRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instantiates_uri', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(), null=True, size=None)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('active', 'Active'), ('on-hold', 'On Hold'), ('revoked', 'Revoked'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], default='active', max_length=255)),
                ('intent', models.CharField(choices=[('proposal', 'Proposal'), ('plan', 'Plan'), ('order', 'Order'), ('original-order', 'Original Order'), ('reflex-order', 'Reflex Order'), ('filler-order', 'Filler Order'), ('instance-order', 'Instance Order'), ('option', 'Option')], default='order', max_length=255)),
                ('priority', models.CharField(choices=[('routine', 'Routine'), ('urgent', 'Urgent'), ('stat', 'Stat'), ('asap', 'Asap')], default='routine', max_length=255)),
                ('do_not_perform', models.BooleanField(default=False)),
                ('quantity', models.IntegerField(null=True)),
                ('occurrence_datetime', models.DateTimeField(null=True)),
                ('occurrence_timing', models.TextField(null=True)),
                ('authored_on', models.DateTimeField(null=True)),
                ('as_needed', models.BooleanField(default=False)),
                ('as_needed_for', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_as_needed_for', to='base.codeableconcept')),
                ('based_on', models.ManyToManyField(blank=True, related_name='device_request_based_on', to='base.reference')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_encounter', to='encounters.encounterreference')),
                ('group_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_group_identifier', to='base.identifier')),
                ('identifier', models.ManyToManyField(blank=True, related_name='device_request_identifier', to='base.identifier')),
                ('note', models.ManyToManyField(blank=True, related_name='device_request_note', to='base.annotation')),
                ('occurrence_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_occurrence_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject_reference_location', to='locations.location')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject_reference_patient', to='patients.patient')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestRequesterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_device', to='devices.device')),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_healthcare_service', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestRequesterCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_codeable_reference_code', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester_codeable_reference_reference', to='devicerequests.devicerequestrequesterreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reference_device_request', to='devicerequests.devicerequest')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestReasonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reason_reference_condition', to='conditions.condition')),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reason_reference_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('document_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reason_reference_document_reference', to='documentreferences.documentreference')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reason_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_reason_reference_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_device', to='devices.device')),
                ('healthcare_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_healthcare_service', to='healthcareservices.healthcareservice')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestPerformerCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer_codeable_reference_reference', to='devicerequests.devicerequestperformerreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceRequestParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_boolean', models.BooleanField(default=False)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_parameter_code', to='base.codeableconcept')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_parameter_value_codeable_concept', to='base.codeableconcept')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_parameter_value_quantity', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_parameter_value_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='parameter',
            field=models.ManyToManyField(blank=True, related_name='device_request_parameter', to='devicerequests.devicerequestparameter'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='performer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_performer', to='devicerequests.devicerequestperformercodeablereference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='reason',
            field=models.ManyToManyField(blank=True, related_name='device_request_reason', to='devicerequests.devicerequestreasonreference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='relevant_history',
            field=models.ManyToManyField(blank=True, related_name='device_request_relevant_history', to='provenances.provenancereference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='replaces',
            field=models.ManyToManyField(blank=True, related_name='device_request_replaces', to='devicerequests.devicerequestreference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='requester',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_requester', to='devicerequests.devicerequestrequesterreference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='subject',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_request_subject', to='devicerequests.devicerequestsubjectreference'),
        ),
        migrations.AddField(
            model_name='devicerequest',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='device_request_supporting_info', to='base.reference'),
        ),
    ]
